/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.io.Serializable;
import org.apache.hudi.client.transaction.lock.LockManager;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.storage.HoodieStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionManager
implements Serializable,
AutoCloseable {
    protected static final Logger LOG = LoggerFactory.getLogger(TransactionManager.class);
    protected final LockManager lockManager;
    protected final boolean isLockRequired;
    protected Option<HoodieInstant> changeActionInstant = Option.empty();
    private Option<HoodieInstant> lastCompletedActionInstant = Option.empty();

    public TransactionManager(HoodieWriteConfig config, HoodieStorage storage) {
        this(new LockManager(config, storage), config.isLockRequired());
    }

    protected TransactionManager(LockManager lockManager, boolean isLockRequired) {
        this.lockManager = lockManager;
        this.isLockRequired = isLockRequired;
    }

    public void beginStateChange(Option<HoodieInstant> changeActionInstant, Option<HoodieInstant> lastCompletedActionInstant) {
        if (this.isLockRequired) {
            LOG.info("State change starting for {} with latest completed action instant {}", changeActionInstant, lastCompletedActionInstant);
            this.lockManager.lock();
            this.reset(this.changeActionInstant, changeActionInstant, lastCompletedActionInstant);
            LOG.info("State change started for {} with latest completed action instant {}", changeActionInstant, lastCompletedActionInstant);
        }
    }

    public void endStateChange(Option<HoodieInstant> changeActionInstant) {
        if (this.isLockRequired) {
            LOG.info("State change ending for action instant {}", changeActionInstant);
            if (this.reset(changeActionInstant, (Option<HoodieInstant>)Option.empty(), (Option<HoodieInstant>)Option.empty())) {
                this.lockManager.unlock();
                LOG.info("State change ended for action instant {}", changeActionInstant);
            }
        }
    }

    protected synchronized boolean reset(Option<HoodieInstant> callerInstant, Option<HoodieInstant> changeActionInstant, Option<HoodieInstant> lastCompletedActionInstant) {
        if (!this.changeActionInstant.isPresent() || ((HoodieInstant)this.changeActionInstant.get()).equals(callerInstant.get())) {
            this.changeActionInstant = changeActionInstant;
            this.lastCompletedActionInstant = lastCompletedActionInstant;
            return true;
        }
        return false;
    }

    @Override
    public void close() {
        if (this.isLockRequired) {
            this.lockManager.close();
            LOG.info("Transaction manager closed");
        }
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public Option<HoodieInstant> getLastCompletedTransactionOwner() {
        return this.lastCompletedActionInstant;
    }

    public Option<HoodieInstant> getCurrentTransactionOwner() {
        return this.changeActionInstant;
    }

    public boolean isLockRequired() {
        return this.isLockRequired;
    }
}

