/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction.lock;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.client.transaction.lock.metrics.HoodieLockMetrics;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.lock.LockProvider;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.RetryHelper;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieLockException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StorageConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockManager
implements Serializable,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(LockManager.class);
    private final HoodieWriteConfig writeConfig;
    private final LockConfiguration lockConfiguration;
    private final StorageConfiguration<?> storageConf;
    private final int maxRetries;
    private final long maxWaitTimeInMs;
    private final RetryHelper<Boolean, HoodieLockException> lockRetryHelper;
    private transient HoodieLockMetrics metrics;
    private volatile LockProvider lockProvider;

    public LockManager(HoodieWriteConfig writeConfig, HoodieStorage storage) {
        this(writeConfig, storage, writeConfig.getProps());
    }

    public LockManager(HoodieWriteConfig writeConfig, HoodieStorage storage, TypedProperties lockProps) {
        this.writeConfig = writeConfig;
        this.storageConf = storage.getConf().newInstance();
        this.lockConfiguration = new LockConfiguration((Properties)lockProps);
        this.maxRetries = this.lockConfiguration.getConfig().getInteger("hoodie.write.lock.client.num_retries", Integer.parseInt((String)HoodieLockConfig.LOCK_ACQUIRE_CLIENT_NUM_RETRIES.defaultValue()));
        this.maxWaitTimeInMs = this.lockConfiguration.getConfig().getLong("hoodie.write.lock.client.wait_time_ms_between_retry", Long.parseLong((String)HoodieLockConfig.LOCK_ACQUIRE_CLIENT_RETRY_WAIT_TIME_IN_MILLIS.defaultValue()));
        this.metrics = new HoodieLockMetrics(writeConfig, storage);
        this.lockRetryHelper = new RetryHelper(this.maxWaitTimeInMs, this.maxRetries, this.maxWaitTimeInMs, Arrays.asList(HoodieLockException.class, InterruptedException.class), "acquire lock");
    }

    public void lock() {
        this.lockRetryHelper.start((RetryHelper.CheckedFunction & Serializable)() -> {
            try {
                this.metrics.startLockApiTimerContext();
                if (!this.getLockProvider().tryLock(this.writeConfig.getLockAcquireWaitTimeoutInMs().longValue(), TimeUnit.MILLISECONDS)) {
                    this.metrics.updateLockNotAcquiredMetric();
                    throw new HoodieLockException("Unable to acquire the lock. Current lock owner information : " + this.getLockProvider().getCurrentOwnerLockInfo());
                }
                this.metrics.updateLockAcquiredMetric();
                return true;
            }
            catch (InterruptedException e) {
                throw new HoodieLockException((Throwable)e);
            }
        });
    }

    public void unlock() {
        this.getLockProvider().unlock();
        try {
            this.metrics.updateLockHeldTimerMetrics();
        }
        catch (HoodieException e) {
            LOG.error(String.format("Exception encountered when updating lock metrics: %s", new Object[]{e}));
        }
        this.metrics.updateLockReleaseSuccessMetric();
        this.close();
    }

    public synchronized LockProvider getLockProvider() {
        if (this.lockProvider == null) {
            LOG.info("LockProvider " + this.writeConfig.getLockProviderClass());
            Class[] metricsConstructorTypes = new Class[]{LockConfiguration.class, StorageConfiguration.class, HoodieLockMetrics.class};
            if (ReflectionUtils.hasConstructor((String)this.writeConfig.getLockProviderClass(), (Class[])metricsConstructorTypes)) {
                this.lockProvider = (LockProvider)ReflectionUtils.loadClass((String)this.writeConfig.getLockProviderClass(), (Class[])metricsConstructorTypes, (Object[])new Object[]{this.lockConfiguration, this.storageConf, this.metrics});
            } else {
                LOG.debug("LockProvider does not support HoodieLockMetrics param in constructor, falling back to standard constructor");
                this.lockProvider = (LockProvider)ReflectionUtils.loadClass((String)this.writeConfig.getLockProviderClass(), (Class[])new Class[]{LockConfiguration.class, StorageConfiguration.class}, (Object[])new Object[]{this.lockConfiguration, this.storageConf});
            }
        }
        return this.lockProvider;
    }

    @Override
    public void close() {
        this.closeQuietly();
    }

    private void closeQuietly() {
        try {
            if (this.lockProvider != null) {
                this.lockProvider.close();
                LOG.info("Released connection created for acquiring lock");
                this.lockProvider = null;
            }
        }
        catch (Exception e) {
            LOG.error("Unable to close and release connection created for acquiring lock", (Throwable)e);
        }
    }
}

