/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction.lock;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hudi.client.transaction.lock.models.LockGetResult;
import org.apache.hudi.client.transaction.lock.models.LockUpsertResult;
import org.apache.hudi.client.transaction.lock.models.StorageLockData;
import org.apache.hudi.client.transaction.lock.models.StorageLockFile;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.exception.HoodieLockException;

public interface StorageLockClient
extends AutoCloseable {
    public Pair<LockUpsertResult, Option<StorageLockFile>> tryUpsertLockFile(StorageLockData var1, Option<StorageLockFile> var2);

    public Pair<LockGetResult, Option<StorageLockFile>> readCurrentLockFile();

    public Option<String> readObject(String var1, boolean var2);

    public boolean writeObject(String var1, String var2);

    public static String getLockFolderPath(String basePath) {
        return String.format("%s%s%s", basePath, "/", ".hoodie/.locks");
    }

    public static Pair<String, String> parseBucketAndPath(String uriString) {
        try {
            URI uri = new URI(uriString);
            String bucketName = uri.getAuthority();
            String path = uri.getPath().replaceFirst("/", "");
            if (StringUtils.isNullOrEmpty((String)bucketName)) {
                throw new IllegalArgumentException("URI does not contain a valid bucket name.");
            }
            if (StringUtils.isNullOrEmpty((String)path)) {
                throw new IllegalArgumentException("URI does not contain a valid path.");
            }
            return Pair.of((Object)bucketName, (Object)path);
        }
        catch (URISyntaxException e) {
            throw new HoodieLockException("Failed to parse URI: " + uriString, (Throwable)e);
        }
    }
}

