/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction.lock;

import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hudi.client.transaction.lock.BaseZookeeperBasedLockProvider;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.LockConfiguration;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.hash.HashID;
import org.apache.hudi.storage.StorageConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class ZookeeperBasedImplicitBasePathLockProvider
extends BaseZookeeperBasedLockProvider {
    private static final Logger LOG = LoggerFactory.getLogger(ZookeeperBasedImplicitBasePathLockProvider.class);
    public static final String LOCK_KEY = "lock_key";
    private final String hudiTableBasePath;

    public static String getLockBasePath(String hudiTableBasePath) {
        String lockBasePath = "/tmp/" + HashID.generateXXHashAsString((String)FSUtils.s3aToS3((String)hudiTableBasePath), (HashID.Size)HashID.Size.BITS_64);
        LOG.info("The Zookeeper lock key for the base path {} is {}", (Object)hudiTableBasePath, (Object)lockBasePath);
        return lockBasePath;
    }

    public ZookeeperBasedImplicitBasePathLockProvider(LockConfiguration lockConfiguration, StorageConfiguration<?> conf) {
        super(lockConfiguration, conf);
        this.hudiTableBasePath = FSUtils.s3aToS3((String)lockConfiguration.getConfig().getString(HoodieCommonConfig.BASE_PATH.key()));
    }

    @Override
    protected String getZkBasePath(LockConfiguration lockConfiguration) {
        String hudiTableBasePath = lockConfiguration.getConfig().getString(HoodieCommonConfig.BASE_PATH.key());
        ValidationUtils.checkArgument((hudiTableBasePath != null ? 1 : 0) != 0);
        return ZookeeperBasedImplicitBasePathLockProvider.getLockBasePath(hudiTableBasePath);
    }

    @Override
    protected String getLockKey(LockConfiguration lockConfiguration) {
        return LOCK_KEY;
    }

    @Override
    protected String generateLogSuffixString() {
        return StringUtils.join((String[])new String[]{"ZkBasePath = ", this.zkBasePath, ", lock key = ", this.lockKey, ", hudi table base path = ", this.hudiTableBasePath});
    }
}

