/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction.lock.audit;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.hudi.client.transaction.lock.StorageLockClient;
import org.apache.hudi.client.transaction.lock.audit.AuditService;
import org.apache.hudi.client.transaction.lock.audit.StorageLockProviderAuditService;
import org.apache.hudi.common.util.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(AuditServiceFactory.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static Option<AuditService> createLockProviderAuditService(String ownerId, String basePath, StorageLockClient storageLockClient, long transactionStartTime, Function<Long, Long> lockExpirationFunction, Supplier<Boolean> lockHeldSupplier) {
        if (!AuditServiceFactory.isAuditEnabled(basePath, storageLockClient)) {
            return Option.empty();
        }
        return Option.of((Object)new StorageLockProviderAuditService(basePath, ownerId, transactionStartTime, storageLockClient, lockExpirationFunction, lockHeldSupplier));
    }

    private static boolean isAuditEnabled(String basePath, StorageLockClient storageLockClient) {
        try {
            String auditConfigPath = StorageLockProviderAuditService.getAuditConfigPath(basePath);
            LOG.debug("Checking for audit configuration at: {}", (Object)auditConfigPath);
            Option<String> jsonContent = storageLockClient.readObject(auditConfigPath, true);
            if (jsonContent.isPresent()) {
                boolean isEnabled;
                LOG.debug("Audit configuration file found, parsing content");
                JsonNode rootNode = OBJECT_MAPPER.readTree((String)jsonContent.get());
                JsonNode enabledNode = rootNode.get("STORAGE_LOCK_AUDIT_SERVICE_ENABLED");
                boolean bl = isEnabled = enabledNode != null && enabledNode.asBoolean(false);
                if (isEnabled) {
                    LOG.info("Audit logging is ENABLED for lock operations at base path: {}", (Object)basePath);
                } else {
                    LOG.info("Audit configuration present but audit logging is DISABLED");
                }
                return isEnabled;
            }
            LOG.debug("No audit configuration file found at: {}", (Object)auditConfigPath);
            return false;
        }
        catch (Exception e) {
            LOG.error("Error reading audit configuration from base path: {}. Audit will be disabled.", (Object)basePath, (Object)e);
            return false;
        }
    }
}

