/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction.lock.audit;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.hudi.client.transaction.lock.StorageLockClient;
import org.apache.hudi.client.transaction.lock.audit.AuditOperationState;
import org.apache.hudi.client.transaction.lock.audit.AuditService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageLockProviderAuditService
implements AuditService {
    private static final Logger LOG = LoggerFactory.getLogger(StorageLockProviderAuditService.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    public static final String AUDIT_FOLDER_NAME = "audit";
    public static final String AUDIT_CONFIG_FILE_NAME = "audit_enabled.json";
    public static final String STORAGE_LOCK_AUDIT_SERVICE_ENABLED_FIELD = "STORAGE_LOCK_AUDIT_SERVICE_ENABLED";
    private final String ownerId;
    private final long transactionStartTime;
    private final String auditFilePath;
    private final StorageLockClient storageLockClient;
    private final Function<Long, Long> lockExpirationFunction;
    private final Supplier<Boolean> lockHeldSupplier;
    private final StringBuilder auditBuffer;

    public static String getAuditConfigPath(String basePath) {
        String lockFolderPath = StorageLockClient.getLockFolderPath(basePath);
        return String.format("%s%s%s", lockFolderPath, "/", AUDIT_CONFIG_FILE_NAME);
    }

    public static String getAuditFolderPath(String basePath) {
        String lockFolderPath = StorageLockClient.getLockFolderPath(basePath);
        return String.format("%s%s%s", lockFolderPath, "/", AUDIT_FOLDER_NAME);
    }

    public StorageLockProviderAuditService(String basePath, String ownerId, long transactionStartTime, StorageLockClient storageLockClient, Function<Long, Long> lockExpirationFunction, Supplier<Boolean> lockHeldSupplier) {
        this.ownerId = ownerId;
        this.transactionStartTime = transactionStartTime;
        this.storageLockClient = storageLockClient;
        this.lockExpirationFunction = lockExpirationFunction;
        this.lockHeldSupplier = lockHeldSupplier;
        this.auditBuffer = new StringBuilder();
        String filename = String.format("%d_%s.jsonl", transactionStartTime, ownerId);
        this.auditFilePath = String.format("%s%s%s", StorageLockProviderAuditService.getAuditFolderPath(basePath), "/", filename);
        LOG.debug("Initialized audit service for transaction starting at {} with file: {}", (Object)transactionStartTime, (Object)this.auditFilePath);
    }

    @Override
    public synchronized void recordOperation(AuditOperationState state, long timestamp) throws Exception {
        HashMap<String, Object> auditRecord = new HashMap<String, Object>();
        auditRecord.put("ownerId", this.ownerId);
        auditRecord.put("transactionStartTime", this.transactionStartTime);
        auditRecord.put("timestamp", timestamp);
        auditRecord.put("state", state.name());
        auditRecord.put("lockExpiration", this.lockExpirationFunction.apply(timestamp));
        auditRecord.put("lockHeld", this.lockHeldSupplier.get());
        String jsonLine = OBJECT_MAPPER.writeValueAsString(auditRecord) + "\n";
        this.auditBuffer.append(jsonLine);
        this.writeAuditFile();
        LOG.debug("Recorded audit operation: state={}, timestamp={}, file={}", new Object[]{state, timestamp, this.auditFilePath});
    }

    private void writeAuditFile() {
        try {
            String content = this.auditBuffer.toString();
            boolean success = this.storageLockClient.writeObject(this.auditFilePath, content);
            if (success) {
                LOG.debug("Successfully wrote audit records to: {}", (Object)this.auditFilePath);
            } else {
                LOG.warn("Failed to write audit records to: {}", (Object)this.auditFilePath);
            }
        }
        catch (Exception e) {
            LOG.warn("Failed to write audit records to: {}", (Object)this.auditFilePath, (Object)e);
        }
    }

    @Override
    public synchronized void close() throws Exception {
        LOG.debug("Closed StorageLockProviderAuditService for transaction: {}, owner: {}", (Object)this.transactionStartTime, (Object)this.ownerId);
    }
}

