/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction.lock.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Reservoir;
import com.codahale.metrics.SlidingWindowReservoir;
import com.codahale.metrics.Timer;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.storage.HoodieStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieLockMetrics {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieLockMetrics.class);
    public static final String LOCK_ACQUIRE_ATTEMPTS_COUNTER_NAME = "lock.acquire.attempts";
    public static final String LOCK_ACQUIRE_SUCCESS_COUNTER_NAME = "lock.acquire.success";
    public static final String LOCK_ACQUIRE_FAILURES_COUNTER_NAME = "lock.acquire.failure";
    public static final String LOCK_RELEASE_SUCCESS_COUNTER_NAME = "lock.release.success";
    public static final String LOCK_ACQUIRE_DURATION_TIMER_NAME = "lock.acquire.duration";
    public static final String LOCK_REQUEST_LATENCY_TIMER_NAME = "lock.request.latency";
    public static final String LOCK_ACQUIRED_BY_OTHERS_ERROR_COUNTER_NAME = "lock.acquired.others.error";
    public static final String LOCK_STATE_UNKNOWN_COUNTER_NAME = "lock.state.unknown";
    public static final String LOCK_ACQUIRE_PRECONDITION_FAILURE_COUNTER_NAME = "lock.acquire.precondition.failure";
    public static final String LOCK_PROVIDER_FATAL_ERROR_COUNTER_NAME = "lock.provider.fatal.error";
    public static final String LOCK_RELEASE_FAILURE_COUNTER_NAME = "lock.release.failure";
    public static final String LOCK_EXPIRATION_DEADLINE_COUNTER_NAME = "lock.expiration.deadline";
    public static final String LOCK_DANGLING_COUNTER_NAME = "lock.dangling";
    public static final String LOCK_INTERRUPTED_COUNTER_NAME = "lock.interrupted";
    private final HoodieWriteConfig writeConfig;
    private final boolean isMetricsEnabled;
    private final int keepLastNtimes = 100;
    private final transient HoodieTimer lockDurationTimer = HoodieTimer.create();
    private final transient HoodieTimer lockApiRequestDurationTimer = HoodieTimer.create();
    private transient Counter lockAttempts;
    private transient Counter successfulLockAttempts;
    private transient Counter failedLockAttempts;
    private transient Counter lockReleaseSuccess;
    private transient Counter lockAcquiredByOthersError;
    private transient Counter lockStateUnknown;
    private transient Counter lockAcquirePreconditionFailure;
    private transient Counter lockProviderFatalError;
    private transient Counter lockReleaseFailure;
    private transient Counter lockDangling;
    private transient Counter lockInterrupted;
    private transient Timer lockDuration;
    private transient Timer lockApiRequestDuration;
    private static final Object REGISTRY_LOCK = new Object();
    private Metrics metrics;

    public HoodieLockMetrics(HoodieWriteConfig writeConfig, HoodieStorage storage) {
        this.isMetricsEnabled = writeConfig.isLockingMetricsEnabled();
        this.writeConfig = writeConfig;
        if (this.isMetricsEnabled) {
            this.metrics = Metrics.getInstance((HoodieMetricsConfig)writeConfig.getMetricsConfig(), (HoodieStorage)storage);
            MetricRegistry registry = this.metrics.getRegistry();
            this.lockAttempts = registry.counter(this.getMetricsName(LOCK_ACQUIRE_ATTEMPTS_COUNTER_NAME));
            this.successfulLockAttempts = registry.counter(this.getMetricsName(LOCK_ACQUIRE_SUCCESS_COUNTER_NAME));
            this.failedLockAttempts = registry.counter(this.getMetricsName(LOCK_ACQUIRE_FAILURES_COUNTER_NAME));
            this.lockReleaseSuccess = registry.counter(this.getMetricsName(LOCK_RELEASE_SUCCESS_COUNTER_NAME));
            this.lockAcquiredByOthersError = registry.counter(this.getMetricsName(LOCK_ACQUIRED_BY_OTHERS_ERROR_COUNTER_NAME));
            this.lockStateUnknown = registry.counter(this.getMetricsName(LOCK_STATE_UNKNOWN_COUNTER_NAME));
            this.lockAcquirePreconditionFailure = registry.counter(this.getMetricsName(LOCK_ACQUIRE_PRECONDITION_FAILURE_COUNTER_NAME));
            this.lockProviderFatalError = registry.counter(this.getMetricsName(LOCK_PROVIDER_FATAL_ERROR_COUNTER_NAME));
            this.lockReleaseFailure = registry.counter(this.getMetricsName(LOCK_RELEASE_FAILURE_COUNTER_NAME));
            this.lockDangling = registry.counter(this.getMetricsName(LOCK_DANGLING_COUNTER_NAME));
            this.lockInterrupted = registry.counter(this.getMetricsName(LOCK_INTERRUPTED_COUNTER_NAME));
            this.lockDuration = this.createTimerForMetrics(registry, LOCK_ACQUIRE_DURATION_TIMER_NAME);
            this.lockApiRequestDuration = this.createTimerForMetrics(registry, LOCK_REQUEST_LATENCY_TIMER_NAME);
        }
    }

    private String getMetricsName(String metric) {
        return this.writeConfig == null ? null : String.format("%s.%s", this.writeConfig.getMetricReporterMetricsNamePrefix(), metric);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timer createTimerForMetrics(MetricRegistry registry, String metric) {
        String metricName = this.getMetricsName(metric);
        if (registry.getMetrics().get(metricName) == null) {
            Object object = REGISTRY_LOCK;
            synchronized (object) {
                if (registry.getMetrics().get(metricName) == null) {
                    this.lockDuration = new Timer((Reservoir)new SlidingWindowReservoir(100));
                    registry.register(metricName, (Metric)this.lockDuration);
                    return this.lockDuration;
                }
            }
        }
        return (Timer)registry.getMetrics().get(metricName);
    }

    public void startLockApiTimerContext() {
        if (this.isMetricsEnabled) {
            this.lockApiRequestDurationTimer.startTimer();
        }
    }

    private static void updateMetric(HoodieTimer timer, Timer metric, String lockName) {
        Option durationMs = timer.tryEndTimer();
        if (durationMs.isPresent()) {
            metric.update(((Long)durationMs.get()).longValue(), TimeUnit.MILLISECONDS);
        } else {
            LOG.info("Unable to get lock {} duration", (Object)lockName);
        }
    }

    public void updateLockAcquiredMetric() {
        if (this.isMetricsEnabled) {
            HoodieLockMetrics.updateMetric(this.lockApiRequestDurationTimer, this.lockApiRequestDuration, "acquired");
            this.lockAttempts.inc();
            this.successfulLockAttempts.inc();
            this.lockDurationTimer.startTimer();
        }
    }

    public void updateLockNotAcquiredMetric() {
        if (this.isMetricsEnabled) {
            HoodieLockMetrics.updateMetric(this.lockApiRequestDurationTimer, this.lockApiRequestDuration, "acquired");
            this.failedLockAttempts.inc();
        }
    }

    public void updateLockHeldTimerMetrics() {
        if (this.isMetricsEnabled && this.lockDurationTimer != null) {
            HoodieLockMetrics.updateMetric(this.lockDurationTimer, this.lockDuration, "held");
        }
    }

    public void updateLockReleaseSuccessMetric() {
        if (this.isMetricsEnabled) {
            this.lockReleaseSuccess.inc();
        }
    }

    public void updateLockAcquiredByOthersErrorMetric() {
        if (this.isMetricsEnabled) {
            this.lockAcquiredByOthersError.inc();
        }
    }

    public void updateLockStateUnknownMetric() {
        if (this.isMetricsEnabled) {
            this.lockStateUnknown.inc();
        }
    }

    public void updateLockAcquirePreconditionFailureMetric() {
        if (this.isMetricsEnabled) {
            this.lockAcquirePreconditionFailure.inc();
        }
    }

    public void updateLockProviderFatalErrorMetric() {
        if (this.isMetricsEnabled) {
            this.lockProviderFatalError.inc();
        }
    }

    public void updateLockReleaseFailureMetric() {
        if (this.isMetricsEnabled) {
            this.lockReleaseFailure.inc();
        }
    }

    public void updateLockExpirationDeadlineMetric(int deadlineMs) {
        if (this.isMetricsEnabled) {
            this.metrics.registerGauge(this.getMetricsName(LOCK_EXPIRATION_DEADLINE_COUNTER_NAME), deadlineMs >= 0 ? (long)deadlineMs : 0L);
        }
    }

    public void updateLockDanglingMetric() {
        if (this.isMetricsEnabled) {
            this.lockDangling.inc();
        }
    }

    public void updateLockInterruptedMetric() {
        if (this.isMetricsEnabled) {
            this.lockInterrupted.inc();
        }
    }
}

