/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.hudi.common.util.ValidationUtils;

public class ConcatenatingIterator<T>
implements Iterator<T> {
    private final Queue<Iterator<T>> allIterators;

    public ConcatenatingIterator(List<? extends Iterator<T>> iterators) {
        this.allIterators = new LinkedList<Iterator<T>>(iterators);
    }

    @Override
    public boolean hasNext() {
        while (!this.allIterators.isEmpty()) {
            if (this.allIterators.peek().hasNext()) {
                return true;
            }
            this.advanceIterator();
        }
        return false;
    }

    protected Iterator<T> advanceIterator() {
        return this.allIterators.poll();
    }

    @Override
    public T next() {
        ValidationUtils.checkArgument((boolean)this.hasNext(), (String)"No more elements left");
        return this.allIterators.peek().next();
    }
}

