/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.estimator;

import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.apache.hudi.common.data.HoodieAtomicLongAccumulator;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.estimator.RecordSizeEstimator;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AverageRecordSizeEstimator
extends RecordSizeEstimator {
    private static final Logger LOG = LoggerFactory.getLogger(AverageRecordSizeEstimator.class);
    private static final Set<String> RECORD_SIZE_ESTIMATE_ACTIONS = CollectionUtils.createSet((Object[])new String[]{"commit", "deltacommit", "compaction"});

    public AverageRecordSizeEstimator(HoodieWriteConfig writeConfig) {
        super(writeConfig);
    }

    @Override
    public long averageBytesPerRecord(HoodieTimeline commitTimeline, CommitMetadataSerDe commitMetadataSerDe) {
        int maxCommits = this.hoodieWriteConfig.getRecordSizeEstimatorMaxCommits();
        long commitSizeThreshold = (long)(this.hoodieWriteConfig.getRecordSizeEstimationThreshold() * (double)this.hoodieWriteConfig.getParquetSmallFileLimit());
        long metadataSizeEstimate = this.hoodieWriteConfig.getRecordSizeEstimatorAverageMetadataSize();
        try {
            if (!commitTimeline.empty()) {
                Iterator instants = commitTimeline.filterCompletedInstants().getReverseOrderedInstants().filter(s -> RECORD_SIZE_ESTIMATE_ACTIONS.contains(s.getAction())).limit(maxCommits).iterator();
                while (instants.hasNext()) {
                    HoodieInstant instant = (HoodieInstant)instants.next();
                    try {
                        HoodieCommitMetadata commitMetadata = commitTimeline.readCommitMetadata(instant);
                        HoodieAtomicLongAccumulator totalBytesWritten = HoodieAtomicLongAccumulator.create();
                        HoodieAtomicLongAccumulator totalRecordsWritten = HoodieAtomicLongAccumulator.create();
                        if (instant.getAction().equals("deltacommit")) {
                            commitMetadata.getWriteStats().stream().filter(hoodieWriteStat -> FSUtils.isBaseFile((StoragePath)new StoragePath(hoodieWriteStat.getPath()))).forEach(hoodieWriteStat -> {
                                totalBytesWritten.add(hoodieWriteStat.getTotalWriteBytes() - metadataSizeEstimate);
                                totalRecordsWritten.add(hoodieWriteStat.getNumWrites());
                            });
                        } else {
                            totalBytesWritten.add(commitMetadata.fetchTotalBytesWritten() - commitMetadata.fetchTotalFiles() * metadataSizeEstimate);
                            totalRecordsWritten.add(commitMetadata.fetchTotalRecordsWritten());
                        }
                        if (totalBytesWritten.value() <= commitSizeThreshold || totalRecordsWritten.value() <= 0L) continue;
                        return (long)Math.ceil(1.0 * (double)totalBytesWritten.value() / (double)totalRecordsWritten.value());
                    }
                    catch (IOException ignore) {
                        LOG.info("Failed to parse commit metadata", (Throwable)ignore);
                    }
                }
            }
        }
        catch (Throwable t) {
            LOG.info("Got error while trying to compute average bytes/record but will proceed to use the computed value or fallback to default config value ", t);
        }
        return this.hoodieWriteConfig.getCopyOnWriteRecordSizeEstimate();
    }
}

