/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.estimator;

import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.estimator.AverageRecordSizeEstimator;
import org.apache.hudi.estimator.RecordSizeEstimator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordSizeEstimatorFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RecordSizeEstimatorFactory.class);

    public static RecordSizeEstimator createRecordSizeEstimator(HoodieWriteConfig writeConfig) {
        String recordSizeEstimatorClass = writeConfig.getRecordSizeEstimator();
        try {
            return (RecordSizeEstimator)ReflectionUtils.loadClass((String)recordSizeEstimatorClass, (Object[])new Object[]{writeConfig});
        }
        catch (Throwable e) {
            LOG.warn("Unable to instantiate the record estimator implementation {}. Falling back to use default AverageRecordSizeEstimator.\" ", (Object)recordSizeEstimatorClass, (Object)e);
            return new AverageRecordSizeEstimator(writeConfig);
        }
    }
}

