/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bucket;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.keygen.KeyGenUtils;

public class BucketIdentifier
implements Serializable {
    private static final String CONSTANT_FILE_ID_SUFFIX = "-0000-0000-0000-000000000000";

    public static int getBucketId(String recordKey, List<String> indexKeyFields, int numBuckets) {
        return BucketIdentifier.getBucketId(BucketIdentifier.getHashKeys(recordKey, indexKeyFields), numBuckets);
    }

    public static int getBucketId(String recordKey, String indexKeyFields, int numBuckets) {
        return BucketIdentifier.getBucketId(BucketIdentifier.getHashKeys(recordKey, indexKeyFields), numBuckets);
    }

    public static int getBucketId(List<String> hashKeyFields, int numBuckets) {
        return (hashKeyFields.hashCode() & Integer.MAX_VALUE) % numBuckets;
    }

    protected static List<String> getHashKeys(String recordKey, String indexKeyFields) {
        return BucketIdentifier.getHashKeysUsingIndexFields(recordKey, Arrays.asList(indexKeyFields.split(",")));
    }

    protected static List<String> getHashKeys(String recordKey, List<String> indexKeyFields) {
        return BucketIdentifier.getHashKeysUsingIndexFields(recordKey, indexKeyFields);
    }

    private static List<String> getHashKeysUsingIndexFields(String recordKey, List<String> indexKeyFields) {
        return Arrays.asList(KeyGenUtils.extractRecordKeysByFields(recordKey, indexKeyFields));
    }

    public static String partitionBucketIdStr(String partition, int bucketId) {
        StringBuilder sb = new StringBuilder().append(partition).append('_');
        return BucketIdentifier.appendWithPadZero(bucketId, 8, sb).toString();
    }

    public static int bucketIdFromFileId(String fileId) {
        return Integer.parseInt(fileId.substring(0, 8));
    }

    public static String bucketIdStr(int n) {
        return BucketIdentifier.appendWithPadZero(n, 8, new StringBuilder()).toString();
    }

    private static StringBuilder appendWithPadZero(int num, int targetLength, StringBuilder sb) {
        String numStr = Integer.toString(num);
        int zerosNeeded = targetLength - numStr.length();
        for (int i = 0; i < zerosNeeded; ++i) {
            sb.append('0');
        }
        sb.append(numStr);
        return sb;
    }

    public static String newBucketFileIdPrefix(int bucketId, boolean fixed) {
        return fixed ? BucketIdentifier.bucketIdStr(bucketId) + CONSTANT_FILE_ID_SUFFIX : BucketIdentifier.newBucketFileIdPrefix(bucketId);
    }

    public static String newBucketFileIdPrefix(int bucketId) {
        return BucketIdentifier.newBucketFileIdPrefix(BucketIdentifier.bucketIdStr(bucketId));
    }

    public static String newBucketFileIdPrefix(String bucketIdStr) {
        return FSUtils.createNewFileIdPfx().replaceFirst(".{8}", bucketIdStr);
    }

    public static String newBucketFileIdForNBCC(int bucketId) {
        return BucketIdentifier.newBucketFileIdForNBCC(BucketIdentifier.bucketIdStr(bucketId));
    }

    public static String newBucketFileIdForNBCC(String bucketIdStr) {
        return FSUtils.createNewFileId((String)(bucketIdStr + CONSTANT_FILE_ID_SUFFIX), (int)0);
    }
}

