/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bucket.partition;

import java.io.Serializable;
import org.apache.hudi.common.model.PartitionBucketIndexHashingConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.bucket.partition.PartitionBucketIndexCalculator;
import org.apache.hudi.index.bucket.partition.PartitionBucketIndexUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumBucketsFunction
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(NumBucketsFunction.class);
    private final int defaultBucketsNum;
    private final boolean isPartitionLevelBucketIndexEnabled;
    private final PartitionBucketIndexCalculator calculator;

    public NumBucketsFunction(String expressions, String ruleType, int defaultBucketsNum) {
        this.defaultBucketsNum = defaultBucketsNum;
        this.isPartitionLevelBucketIndexEnabled = StringUtils.nonEmpty((String)expressions);
        if (this.isPartitionLevelBucketIndexEnabled) {
            this.calculator = PartitionBucketIndexCalculator.getInstance(expressions, ruleType, defaultBucketsNum);
            LOG.info("Initialized partition-level bucket index with expressions: {}, rule: {}, default bucket number: {}", new Object[]{expressions, ruleType, defaultBucketsNum});
        } else {
            this.calculator = null;
            LOG.info("Using fixed bucket number: {}", (Object)defaultBucketsNum);
        }
    }

    public NumBucketsFunction(int defaultBucketsNum) {
        this.defaultBucketsNum = defaultBucketsNum;
        this.isPartitionLevelBucketIndexEnabled = false;
        this.calculator = null;
    }

    public static NumBucketsFunction fromWriteConfig(HoodieWriteConfig writeConfig) {
        String expression = writeConfig.getBucketIndexPartitionExpression();
        String ruleType = writeConfig.getBucketIndexPartitionRuleType();
        int numBuckets = writeConfig.getBucketIndexNumBuckets();
        return new NumBucketsFunction(expression, ruleType, numBuckets);
    }

    public static NumBucketsFunction fromMetaClient(HoodieTableMetaClient metaClient, int defaultBucketNumber) {
        if (PartitionBucketIndexUtils.isPartitionSimpleBucketIndex(metaClient.getStorageConf(), metaClient.getBasePath().toString())) {
            PartitionBucketIndexHashingConfig hashingConfig = PartitionBucketIndexHashingConfig.loadingLatestHashingConfig((HoodieTableMetaClient)metaClient);
            return new NumBucketsFunction(hashingConfig.getExpressions(), hashingConfig.getRule(), hashingConfig.getDefaultBucketNumber());
        }
        return new NumBucketsFunction(defaultBucketNumber);
    }

    public int getNumBuckets(String partitionPath) {
        if (this.isPartitionLevelBucketIndexEnabled && this.calculator != null) {
            return this.calculator.computeNumBuckets(partitionPath);
        }
        return this.defaultBucketsNum;
    }

    public int getDefaultBucketNumber() {
        return this.defaultBucketsNum;
    }

    public boolean isPartitionLevelBucketIndexEnabled() {
        return this.isPartitionLevelBucketIndexEnabled;
    }
}

