/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bucket.partition;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hudi.index.bucket.partition.PartitionBucketIndexRule;
import org.apache.hudi.index.bucket.partition.RegexRuleEngine;
import org.apache.hudi.index.bucket.partition.RuleEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionBucketIndexCalculator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(PartitionBucketIndexCalculator.class);
    private static final HashMap<String, PartitionBucketIndexCalculator> INSTANCES = new HashMap();
    private static final int CACHE_SIZE = 100000;
    private final int defaultBucketNumber;
    private final Cache<String, Integer> partitionToBucketCache;
    private final RuleEngine ruleEngine;

    private PartitionBucketIndexCalculator(String expressions, String ruleType, int defaultBucketNumber) {
        this.defaultBucketNumber = defaultBucketNumber;
        this.ruleEngine = PartitionBucketIndexCalculator.createRuleEngine(ruleType, expressions);
        this.partitionToBucketCache = Caffeine.newBuilder().maximumSize(100000L).build();
    }

    public static PartitionBucketIndexCalculator getInstance(String expressions, String rule, int defaultBucketNumber) {
        return INSTANCES.computeIfAbsent(expressions, key -> {
            LOG.info("Creating new {} instance for expressions: {}", PartitionBucketIndexCalculator.class, key);
            return new PartitionBucketIndexCalculator(expressions, rule, defaultBucketNumber);
        });
    }

    public int computeNumBuckets(String partitionPath) {
        Integer cachedBucketNumber = (Integer)this.partitionToBucketCache.getIfPresent((Object)partitionPath);
        if (cachedBucketNumber != null) {
            return cachedBucketNumber;
        }
        int bucketNumber = this.ruleEngine.calculateNumBuckets(partitionPath);
        if (bucketNumber == -1) {
            bucketNumber = this.defaultBucketNumber;
            LOG.debug("No rule matched for partition: {}. Using default bucket number: {}", (Object)partitionPath, (Object)this.defaultBucketNumber);
        }
        this.partitionToBucketCache.put((Object)partitionPath, (Object)bucketNumber);
        return bucketNumber;
    }

    public Map<String, Integer> getAllBucketNumbers(List<String> partitions) {
        for (String partition : partitions) {
            this.computeNumBuckets(partition);
        }
        return this.getPartitionToBucket();
    }

    public void cleanCache() {
        INSTANCES.clear();
    }

    public int getDefaultBucketNumber() {
        return this.defaultBucketNumber;
    }

    public long getCacheSize() {
        return this.partitionToBucketCache.estimatedSize();
    }

    public Map<String, Integer> getPartitionToBucket() {
        return this.partitionToBucketCache.asMap();
    }

    private static RuleEngine createRuleEngine(String ruleType, String expressions) {
        switch (PartitionBucketIndexRule.valueOf(ruleType.toUpperCase())) {
            case REGEX: {
                return new RegexRuleEngine(expressions);
            }
        }
        LOG.error("Unsupported rule type: {}.", (Object)ruleType);
        throw new UnsupportedOperationException("Unsupported rule type " + ruleType);
    }
}

