/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bucket.partition;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.common.model.PartitionBucketIndexHashingConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.hadoop.fs.HadoopFSUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionBucketIndexUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionBucketIndexUtils.class);

    public static boolean isPartitionSimpleBucketIndex(Configuration conf, String basePath) {
        return PartitionBucketIndexUtils.isPartitionSimpleBucketIndex(HadoopFSUtils.getStorageConf((Configuration)conf), basePath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isPartitionSimpleBucketIndex(StorageConfiguration conf, String basePath) {
        StoragePath storagePath = PartitionBucketIndexHashingConfig.getHashingConfigStorageFolder((String)basePath);
        try (HoodieHadoopStorage storage = new HoodieHadoopStorage(storagePath, conf);){
            boolean bl = storage.exists(storagePath);
            return bl;
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to list PARTITION_BUCKET_INDEX_HASHING_FOLDER folder ", e);
        }
    }

    @VisibleForTesting
    public static List<String> getAllFileIDWithPartition(HoodieTableMetaClient metaClient) throws IOException {
        List allFiles = metaClient.getStorage().listDirectEntries(metaClient.getBasePath()).stream().flatMap(path -> {
            try {
                return metaClient.getStorage().listDirectEntries(path.getPath()).stream();
            }
            catch (IOException e) {
                return Stream.empty();
            }
        }).collect(Collectors.toList());
        HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(metaClient, metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants(), allFiles);
        return fsView.getAllFileGroups().map(group -> group.getPartitionPath() + group.getFileGroupId().getFileId().split("-")[0]).collect(Collectors.toList());
    }
}

