/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bucket.partition;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.index.bucket.partition.PartitionBucketIndexCalculator;
import org.apache.hudi.index.bucket.partition.RuleEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexRuleEngine
implements RuleEngine {
    private static final Logger LOG = LoggerFactory.getLogger(PartitionBucketIndexCalculator.class);
    private static final long serialVersionUID = 1L;
    private final List<RegexRule> rules = new ArrayList<RegexRule>();

    public RegexRuleEngine(String expressions) {
        this.parseExpressions(expressions);
    }

    private void parseExpressions(String expressions) {
        String[] ruleExpressions;
        for (String ruleExpression : ruleExpressions = expressions.split(";")) {
            int bucketNumber;
            String[] parts = ruleExpression.trim().split(",");
            if (parts.length != 2) {
                throw new HoodieException("Invalid regex expression format. Expected 'pattern,bucketNumber' but got: " + ruleExpression);
            }
            String regex = parts[0].trim();
            try {
                bucketNumber = Integer.parseInt(parts[1].trim());
            }
            catch (NumberFormatException e) {
                throw new HoodieException("Invalid bucket number in expression: " + ruleExpression, (Throwable)e);
            }
            this.rules.add(new RegexRule(regex, bucketNumber));
            LOG.info("Added regex rule: {} with bucket number: {}", (Object)regex, (Object)bucketNumber);
        }
        LOG.info("Initialized {} regex rules", (Object)this.rules.size());
    }

    @Override
    public int calculateNumBuckets(String partitionPath) {
        for (RegexRule rule : this.rules) {
            if (!rule.matches(partitionPath)) continue;
            LOG.debug("Partition '{}' matched regex rule: {}", (Object)partitionPath, (Object)rule);
            return rule.numBuckets;
        }
        return -1;
    }

    private static class RegexRule
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Pattern pattern;
        private final int numBuckets;

        public RegexRule(String regex, int numBuckets) {
            this.pattern = Pattern.compile(regex);
            this.numBuckets = numBuckets;
        }

        public boolean matches(String input) {
            Matcher matcher = this.pattern.matcher(input);
            return matcher.find();
        }

        public String toString() {
            return this.pattern.pattern() + ":" + this.numBuckets;
        }
    }
}

