/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieOperation;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.model.MetadataValues;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieInsertException;
import org.apache.hudi.io.HoodieWriteHandle;
import org.apache.hudi.io.SecondaryIndexStreamingTracker;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCreateHandle<T, I, K, O>
extends HoodieWriteHandle<T, I, K, O> {
    private static final Logger LOG = LoggerFactory.getLogger(BaseCreateHandle.class);
    protected HoodieFileWriter fileWriter;
    protected final StoragePath path;
    protected long recordsWritten = 0L;
    protected long insertRecordsWritten = 0L;
    protected long recordsDeleted = 0L;
    protected Map<String, HoodieRecord<T>> recordMap;
    protected boolean useWriterSchema = false;

    public BaseCreateHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, Option<Schema> overriddenSchema, TaskContextSupplier taskContextSupplier, boolean preserveMetadata) {
        super(config, instantTime, partitionPath, fileId, hoodieTable, overriddenSchema, taskContextSupplier, preserveMetadata);
        this.writeStatus.setFileId(fileId);
        this.writeStatus.setPartitionPath(partitionPath);
        this.writeStatus.setStat(new HoodieWriteStat());
        this.path = this.makeNewPath(partitionPath);
    }

    protected void createPartitionMetadataAndMarkerFile() {
        HoodiePartitionMetadata partitionMetadata = new HoodiePartitionMetadata(this.storage, this.instantTime, new StoragePath(this.config.getBasePath()), FSUtils.constructAbsolutePath((String)this.config.getBasePath(), (String)this.partitionPath), this.hoodieTable.getPartitionMetafileFormat());
        partitionMetadata.trySave();
        this.createMarkerFile(this.partitionPath, FSUtils.makeBaseFileName((String)this.instantTime, (String)this.writeToken, (String)this.fileId, (String)this.hoodieTable.getBaseFileExtension()));
    }

    @Override
    public boolean canWrite(HoodieRecord record) {
        return this.fileWriter.canWrite() && record.getPartitionPath().equals(this.writeStatus.getPartitionPath()) || this.layoutControlsNumFiles();
    }

    @Override
    protected void doWrite(HoodieRecord record, Schema schema, TypedProperties props) {
        Option<Map<String, String>> recordMetadata = this.getRecordMetadata(record, schema, (Properties)props);
        try {
            if (!HoodieOperation.isDelete((HoodieOperation)record.getOperation()) && !record.isDelete(this.deleteContext, (Properties)this.config.getProps())) {
                if (record.shouldIgnore(schema, (Properties)this.config.getProps())) {
                    return;
                }
                this.writeRecordToFile(record, schema);
                record.unseal();
                record.setNewLocation(this.newRecordLocation);
                record.seal();
                ++this.recordsWritten;
                ++this.insertRecordsWritten;
            } else {
                ++this.recordsDeleted;
            }
            this.writeStatus.markSuccess(record, recordMetadata);
            record.deflate();
        }
        catch (Throwable t) {
            this.writeStatus.markFailure(record, t, recordMetadata);
            LOG.error("Error writing record " + record, t);
        }
    }

    public void write() {
        Iterator keyIterator = this.hoodieTable.requireSortedRecords() ? this.recordMap.keySet().stream().sorted().iterator() : this.recordMap.keySet().stream().iterator();
        while (keyIterator.hasNext()) {
            String key = (String)keyIterator.next();
            HoodieRecord<T> record = this.recordMap.get(key);
            this.write(record, this.useWriterSchema ? this.writeSchemaWithMetaFields : this.writeSchema, this.config.getProps());
        }
    }

    protected void writeRecordToFile(HoodieRecord record, Schema schema) throws IOException {
        if (this.preserveMetadata) {
            HoodieRecord<T> populatedRecord = this.updateFileName(record, schema, this.writeSchemaWithMetaFields, this.path.getName(), (Properties)this.config.getProps());
            if (this.isSecondaryIndexStatsStreamingWritesEnabled) {
                SecondaryIndexStreamingTracker.trackSecondaryIndexStats(populatedRecord, this.writeStatus, this.writeSchemaWithMetaFields, this.secondaryIndexDefns, this.config);
            }
            this.fileWriter.write(record.getRecordKey(), populatedRecord, this.writeSchemaWithMetaFields, (Properties)this.config.getProps());
        } else {
            record = record.prependMetaFields(schema, this.writeSchemaWithMetaFields, new MetadataValues(), (Properties)this.config.getProps());
            if (this.isSecondaryIndexStatsStreamingWritesEnabled) {
                SecondaryIndexStreamingTracker.trackSecondaryIndexStats(record, this.writeStatus, this.writeSchemaWithMetaFields, this.secondaryIndexDefns, this.config);
            }
            this.fileWriter.writeWithMetadata(record.getKey(), record, this.writeSchemaWithMetaFields, (Properties)this.config.getProps());
        }
    }

    protected HoodieRecord<T> updateFileName(HoodieRecord<T> record, Schema schema, Schema targetSchema, String fileName, Properties prop) {
        MetadataValues metadataValues = new MetadataValues().setFileName(fileName);
        return record.prependMetaFields(schema, targetSchema, metadataValues, prop);
    }

    @Override
    public IOType getIOType() {
        return IOType.CREATE;
    }

    @Override
    public List<WriteStatus> close() {
        LOG.info("Closing the file " + this.writeStatus.getFileId() + " as we are done with all the records " + this.recordsWritten);
        try {
            if (this.isClosed()) {
                return Collections.singletonList(this.writeStatus);
            }
            this.markClosed();
            if (this.fileWriter != null) {
                this.fileWriter.close();
                this.fileWriter = null;
            }
            this.setupWriteStatus();
            LOG.info("CreateHandle for partitionPath {} fileID {}, took {} ms.", new Object[]{this.writeStatus.getStat().getPartitionPath(), this.writeStatus.getStat().getFileId(), this.writeStatus.getStat().getRuntimeStats().getTotalCreateTime()});
            return Collections.singletonList(this.writeStatus);
        }
        catch (IOException e) {
            throw new HoodieInsertException("Failed to close the Insert Handle for path " + this.path, e);
        }
    }

    protected void setupWriteStatus() throws IOException {
        HoodieWriteStat stat = this.writeStatus.getStat();
        stat.setPartitionPath(this.writeStatus.getPartitionPath());
        stat.setNumWrites(this.recordsWritten);
        stat.setNumDeletes(this.recordsDeleted);
        stat.setNumInserts(this.insertRecordsWritten);
        stat.setPrevCommit("null");
        stat.setFileId(this.writeStatus.getFileId());
        stat.setPath(new StoragePath(this.config.getBasePath()), this.path);
        stat.setTotalWriteErrors(this.writeStatus.getTotalErrorRecords());
        long fileSize = this.storage.getPathInfo(this.path).getLength();
        stat.setTotalWriteBytes(fileSize);
        stat.setFileSizeInBytes(fileSize);
        HoodieWriteStat.RuntimeStats runtimeStats = new HoodieWriteStat.RuntimeStats();
        runtimeStats.setTotalCreateTime(this.timer.endTimer());
        stat.setRuntimeStats(runtimeStats);
    }
}

