/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.stream.Stream;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.HoodieMemoryConfig;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.table.read.HoodieFileGroupReader;
import org.apache.hudi.common.table.read.HoodieReadStats;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.internal.schema.utils.SerDeHelper;
import org.apache.hudi.io.HoodieAppendHandle;
import org.apache.hudi.io.IOUtils;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;

@NotThreadSafe
public class FileGroupReaderBasedAppendHandle<T, I, K, O>
extends HoodieAppendHandle<T, I, K, O> {
    private final HoodieReaderContext<T> readerContext;
    private final CompactionOperation operation;
    private HoodieReadStats readStats;

    public FileGroupReaderBasedAppendHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, CompactionOperation operation, TaskContextSupplier taskContextSupplier, HoodieReaderContext<T> readerContext) {
        super(config, instantTime, hoodieTable, operation.getPartitionPath(), operation.getFileId(), taskContextSupplier);
        this.operation = operation;
        this.readerContext = readerContext;
    }

    @Override
    public void doAppend() {
        boolean usePosition = this.config.getBooleanOrDefault(HoodieReaderConfig.MERGE_USE_RECORD_POSITIONS);
        Option internalSchemaOption = SerDeHelper.fromJson((String)this.config.getInternalSchema());
        TypedProperties props = TypedProperties.copy((Properties)this.config.getProps());
        long maxMemoryPerCompaction = IOUtils.getMaxMemoryPerCompaction(this.taskContextSupplier, this.config);
        props.put((Object)HoodieMemoryConfig.MAX_MEMORY_FOR_MERGE.key(), (Object)String.valueOf(maxMemoryPerCompaction));
        Stream<HoodieLogFile> logFiles = this.operation.getDeltaFileNames().stream().map(logFileName -> new HoodieLogFile(new StoragePath(FSUtils.constructAbsolutePath((String)this.config.getBasePath(), (String)this.operation.getPartitionPath()), logFileName)));
        try (HoodieFileGroupReader fileGroupReader = HoodieFileGroupReader.newBuilder().withReaderContext(this.readerContext).withHoodieTableMetaClient(this.hoodieTable.getMetaClient()).withLatestCommitTime(this.instantTime).withPartitionPath(this.partitionPath).withLogFiles(logFiles).withBaseFileOption(Option.empty()).withDataSchema(this.writeSchemaWithMetaFields).withRequestedSchema(this.writeSchemaWithMetaFields).withInternalSchema(internalSchemaOption).withProps(props).withEmitDelete(true).withShouldUseRecordPosition(usePosition).withSortOutput(this.hoodieTable.requireSortedRecords()).withEnableOptimizedLogBlockScan(true).build();){
            this.recordItr = new CloseableMappingIterator(fileGroupReader.getLogRecordsOnly(), record -> {
                HoodieRecord hoodieRecord = this.readerContext.getRecordContext().constructHoodieRecord(record);
                hoodieRecord.setCurrentLocation(this.newRecordLocation);
                return hoodieRecord;
            });
            this.header.put(HoodieLogBlock.HeaderMetadataType.COMPACTED_BLOCK_TIMES, StringUtils.join((List)fileGroupReader.getValidBlockInstants(), (String)","));
            super.doAppend();
            this.readStats = fileGroupReader.getStats();
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to initialize file group reader for " + this.fileId, e);
        }
    }

    @Override
    public List<WriteStatus> close() {
        try {
            super.close();
            this.writeStatus.getStat().setPartitionPath(this.operation.getPartitionPath());
            this.writeStatus.getStat().setTotalLogReadTimeMs(this.readStats.getTotalLogReadTimeMs());
            this.writeStatus.getStat().setTotalUpdatedRecordsCompacted(this.readStats.getTotalUpdatedRecordsCompacted());
            this.writeStatus.getStat().setTotalLogFilesCompacted(this.readStats.getTotalLogFilesCompacted());
            this.writeStatus.getStat().setTotalLogRecords(this.readStats.getTotalLogRecords());
            this.writeStatus.getStat().setTotalLogBlocks(this.readStats.getTotalLogBlocks());
            this.writeStatus.getStat().setTotalCorruptLogBlock(this.readStats.getTotalCorruptLogBlock());
            this.writeStatus.getStat().setTotalRollbackBlocks(this.readStats.getTotalRollbackBlocks());
            this.writeStatus.getStat().setTotalLogSizeCompacted(((Double)this.operation.getMetrics().get("TOTAL_LOG_FILES_SIZE")).longValue());
            if (this.writeStatus.getStat().getRuntimeStats() != null) {
                this.writeStatus.getStat().getRuntimeStats().setTotalScanTime(this.readStats.getTotalLogReadTimeMs());
            }
            this.writeStatus.getStat().setPrevCommit(this.operation.getBaseInstantTime());
            return Collections.singletonList(this.writeStatus);
        }
        catch (Exception e) {
            throw new HoodieUpsertException("Failed to close " + this.getClass().getSimpleName(), e);
        }
    }
}

