/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.HoodieMergeHandle;
import org.apache.hudi.io.HoodieWriteHandle;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HoodieAbstractMergeHandle<T, I, K, O>
extends HoodieWriteHandle<T, I, K, O>
implements HoodieMergeHandle<T, I, K, O> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieAbstractMergeHandle.class);
    protected Map<String, HoodieRecord<T>> keyToNewRecords;
    protected StoragePath newFilePath;
    protected StoragePath oldFilePath;
    protected Option<BaseKeyGenerator> keyGeneratorOpt;
    protected HoodieBaseFile baseFileToMerge;
    protected Option<String[]> partitionFields = Option.empty();
    protected Object[] partitionValues = new Object[0];

    public HoodieAbstractMergeHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier, HoodieBaseFile baseFile, Option<BaseKeyGenerator> keyGeneratorOpt, boolean preserveMetadata) {
        super(config, instantTime, partitionPath, fileId, hoodieTable, taskContextSupplier, preserveMetadata);
        this.baseFileToMerge = baseFile;
        this.keyGeneratorOpt = keyGeneratorOpt;
        this.initPartitionMetadataAndFilePaths(partitionPath);
        this.initWriteStatus(fileId, partitionPath);
        this.validateAndSetAndKeyGenProps(keyGeneratorOpt, config.populateMetaFields());
    }

    protected HoodieAbstractMergeHandle(HoodieWriteConfig config, String instantTime, String partitionPath, String fileId, HoodieTable<T, I, K, O> hoodieTable, TaskContextSupplier taskContextSupplier, boolean preserveMetadata) {
        super(config, instantTime, partitionPath, fileId, hoodieTable, taskContextSupplier, preserveMetadata);
    }

    @Override
    public StoragePath getOldFilePath() {
        return this.oldFilePath;
    }

    @Override
    public IOType getIOType() {
        return IOType.MERGE;
    }

    @Override
    public HoodieBaseFile baseFileForMerge() {
        return this.baseFileToMerge;
    }

    @Override
    public void setPartitionFields(Option<String[]> partitionFields) {
        this.partitionFields = partitionFields;
    }

    public Option<String[]> getPartitionFields() {
        return this.partitionFields;
    }

    @Override
    public void setPartitionValues(Object[] partitionValues) {
        this.partitionValues = partitionValues;
    }

    public Object[] getPartitionValues() {
        return this.partitionValues;
    }

    private void initPartitionMetadataAndFilePaths(String partitionPath) {
        LOG.info("partitionPath:{}, targetFileId to be merged: {}", (Object)partitionPath, (Object)this.fileId);
        String latestValidFilePath = this.baseFileToMerge == null ? null : this.baseFileToMerge.getFileName();
        HoodiePartitionMetadata partitionMetadata = new HoodiePartitionMetadata(this.storage, this.instantTime, new StoragePath(this.config.getBasePath()), FSUtils.constructAbsolutePath((String)this.config.getBasePath(), (String)partitionPath), this.hoodieTable.getPartitionMetafileFormat());
        partitionMetadata.trySave();
        String newFileName = this.createNewFileName(latestValidFilePath);
        this.oldFilePath = this.makeNewFilePath(partitionPath, latestValidFilePath);
        this.newFilePath = this.makeNewFilePath(partitionPath, newFileName);
        LOG.info("Merging new data into oldPath: {}, as newPath: {}", (Object)this.oldFilePath.toString(), (Object)this.newFilePath.toString());
    }

    private void initWriteStatus(String fileId, String partitionPath) {
        this.writeStatus.setStat(new HoodieWriteStat());
        if (this.baseFileToMerge != null) {
            this.writeStatus.getStat().setPrevCommit(this.baseFileToMerge.getCommitTime());
            this.writeStatus.getStat().setPrevBaseFile(this.baseFileToMerge.getFileName());
        } else {
            this.writeStatus.getStat().setPrevCommit("null");
        }
        this.writeStatus.setFileId(fileId);
        this.writeStatus.setPartitionPath(partitionPath);
        this.writeStatus.getStat().setPartitionPath(partitionPath);
        this.writeStatus.getStat().setFileId(fileId);
        LOG.debug("Initializing Write status with fileId {} partitionPath {}", (Object)fileId, (Object)partitionPath);
        this.setWriteStatusPath();
    }

    private void validateAndSetAndKeyGenProps(Option<BaseKeyGenerator> keyGeneratorOpt, boolean populateMetaFields) {
        ValidationUtils.checkArgument((populateMetaFields == !keyGeneratorOpt.isPresent() ? 1 : 0) != 0);
        this.keyGeneratorOpt = keyGeneratorOpt;
    }

    protected String createNewFileName(String oldFileName) {
        return FSUtils.makeBaseFileName((String)this.instantTime, (String)this.writeToken, (String)this.fileId, (String)this.hoodieTable.getBaseFileExtension());
    }

    protected void makeOldAndNewFilePaths(String partitionPath, String oldFileName, String newFileName) {
        this.oldFilePath = this.makeNewFilePath(partitionPath, oldFileName);
        this.newFilePath = this.makeNewFilePath(partitionPath, newFileName);
    }

    public static HoodieBaseFile getLatestBaseFile(HoodieTable<?, ?, ?, ?> hoodieTable, String partitionPath, String fileId) {
        Option baseFileOp = hoodieTable.getBaseFileOnlyView().getLatestBaseFile(partitionPath, fileId);
        if (!baseFileOp.isPresent()) {
            throw new NoSuchElementException(String.format("FileID %s of partition path %s does not exist.", fileId, partitionPath));
        }
        return (HoodieBaseFile)baseFileOp.get();
    }

    protected void setWriteStatusPath() {
        this.writeStatus.getStat().setPath(new StoragePath(this.config.getBasePath()), this.newFilePath);
    }
}

