/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.HoodieWriteHandle;
import org.apache.hudi.io.storage.HoodieFileBinaryCopier;
import org.apache.hudi.parquet.io.HoodieParquetFileBinaryCopier;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.util.HoodieFileMetadataMerger;
import org.apache.parquet.avro.HoodieAvroParquetSchemaConverter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieBinaryCopyHandle<T, I, K, O>
extends HoodieWriteHandle<T, I, K, O> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieBinaryCopyHandle.class);
    protected final HoodieFileBinaryCopier writer;
    private final List<StoragePath> inputFiles;
    private final StoragePath path;
    private final Configuration conf;
    private final MessageType writeScheMessageType;
    protected long recordsWritten = 0L;
    protected long insertRecordsWritten = 0L;

    private MessageType getWriteSchema(HoodieWriteConfig config, List<StoragePath> inputFiles, Configuration conf, HoodieTable<?, ?, ?, ?> table) {
        if (!config.isBinaryCopySchemaEvolutionEnabled() && !inputFiles.isEmpty()) {
            try {
                ParquetUtils parquetUtils = new ParquetUtils();
                MessageType fileSchema = parquetUtils.readSchema(table.getStorage(), inputFiles.get(0));
                LOG.info("Binary copy schema evolution disabled. Using schema from input file: " + inputFiles.get(0));
                return fileSchema;
            }
            catch (Exception e) {
                LOG.error("Failed to read schema from input file", (Throwable)e);
                throw new HoodieIOException("Failed to read schema from input file when schema evolution is disabled: " + inputFiles.get(0), e instanceof IOException ? (IOException)e : new IOException(e));
            }
        }
        return HoodieAvroParquetSchemaConverter.getAvroSchemaConverter((Configuration)conf).convert(this.writeSchemaWithMetaFields);
    }

    public HoodieBinaryCopyHandle(HoodieWriteConfig config, String instantTime, String partitionPath, String fileId, HoodieTable<T, I, K, O> hoodieTable, TaskContextSupplier taskContextSupplier, List<StoragePath> inputFilePaths) {
        super(config, instantTime, partitionPath, fileId, hoodieTable, taskContextSupplier, true);
        this.inputFiles = inputFilePaths;
        this.conf = (Configuration)hoodieTable.getStorageConf().unwrapAs(Configuration.class);
        this.writeScheMessageType = this.getWriteSchema(config, inputFilePaths, this.conf, hoodieTable);
        HoodieFileMetadataMerger fileMetadataMerger = new HoodieFileMetadataMerger();
        this.path = this.makeNewPath(partitionPath);
        this.writeStatus.setFileId(fileId);
        this.writeStatus.setPartitionPath(partitionPath);
        this.writeStatus.setStat(new HoodieWriteStat());
        this.writer = new HoodieParquetFileBinaryCopier(this.conf, CompressionCodecName.fromConf((String)config.getStringOrDefault(HoodieStorageConfig.PARQUET_COMPRESSION_CODEC_NAME)), fileMetadataMerger);
    }

    public void write() {
        LOG.info("Start to merge source files " + this.inputFiles + " into target file: " + this.path + ". Please pay attention that we will not rolling files based on max-file-size config during binary copy.");
        HoodieTimer timer = HoodieTimer.start();
        long records = 0L;
        try {
            boolean schemaEvolutionEnabled = this.config.isBinaryCopySchemaEvolutionEnabled();
            LOG.info("Schema evolution enabled for binary copy: {}", (Object)schemaEvolutionEnabled);
            records = this.writer.binaryCopy(this.inputFiles, Collections.singletonList(this.path), this.writeScheMessageType, schemaEvolutionEnabled);
        }
        catch (IOException e) {
            throw new HoodieIOException(e.getMessage(), e);
        }
        finally {
            this.recordsWritten = records;
            this.insertRecordsWritten = records;
        }
        LOG.info("Finish rewriting " + this.path + ". Using " + timer.endTimer() + " mills");
    }

    @Override
    public List<WriteStatus> close() {
        LOG.info("Closing the file " + this.writeStatus.getFileId() + " as we are done with all the records " + this.recordsWritten);
        try {
            this.writer.close();
            HoodieWriteStat stat = this.writeStatus.getStat();
            stat.setPartitionPath(this.writeStatus.getPartitionPath());
            stat.setNumWrites(this.recordsWritten);
            stat.setNumInserts(this.insertRecordsWritten);
            stat.setPrevCommit("null");
            stat.setFileId(this.writeStatus.getFileId());
            stat.setPath(new StoragePath(this.config.getBasePath()), this.path);
            stat.setTotalWriteErrors(this.writeStatus.getTotalErrorRecords());
            long fileSize = this.storage.getPathInfo(this.path).getLength();
            stat.setTotalWriteBytes(fileSize);
            stat.setFileSizeInBytes(fileSize);
            HoodieWriteStat.RuntimeStats runtimeStats = new HoodieWriteStat.RuntimeStats();
            runtimeStats.setTotalCreateTime(this.timer.endTimer());
            stat.setRuntimeStats(runtimeStats);
            LOG.info(String.format("HoodieBinaryCopyHandle for partitionPath %s fileID %s, took %d ms.", this.writeStatus.getStat().getPartitionPath(), this.writeStatus.getStat().getFileId(), this.writeStatus.getStat().getRuntimeStats().getTotalCreateTime()));
            return Collections.singletonList(this.writeStatus);
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to close the Binary Copy Handle for path " + this.path, e);
        }
    }

    @Override
    public IOType getIOType() {
        return IOType.CREATE;
    }

    @Override
    public boolean canWrite(HoodieRecord record) {
        return true;
    }
}

