/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.avro.Schema;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieInsertException;
import org.apache.hudi.io.BaseCreateHandle;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.io.storage.HoodieFileWriterFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NotThreadSafe
public class HoodieCreateHandle<T, I, K, O>
extends BaseCreateHandle<T, I, K, O> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieCreateHandle.class);

    public HoodieCreateHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier) {
        this(config, instantTime, hoodieTable, partitionPath, fileId, (Option<Schema>)Option.empty(), taskContextSupplier, false);
    }

    public HoodieCreateHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier, boolean preserveMetadata) {
        this(config, instantTime, hoodieTable, partitionPath, fileId, (Option<Schema>)Option.empty(), taskContextSupplier, preserveMetadata);
    }

    public HoodieCreateHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, Option<Schema> overriddenSchema, TaskContextSupplier taskContextSupplier) {
        this(config, instantTime, hoodieTable, partitionPath, fileId, overriddenSchema, taskContextSupplier, false);
    }

    public HoodieCreateHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, Option<Schema> overriddenSchema, TaskContextSupplier taskContextSupplier, boolean preserveMetadata) {
        super(config, instantTime, hoodieTable, partitionPath, fileId, overriddenSchema, taskContextSupplier, preserveMetadata);
        this.createPartitionMetadataAndMarkerFile();
        try {
            this.fileWriter = this.initializeFileWriter();
        }
        catch (IOException e) {
            throw new HoodieInsertException("Failed to initialize HoodieStorageWriter for path " + this.path, e);
        }
        LOG.info("New CreateHandle for partition {} with fileId {}", (Object)partitionPath, (Object)fileId);
    }

    @VisibleForTesting
    HoodieFileWriter initializeFileWriter() throws IOException {
        return HoodieFileWriterFactory.getFileWriter((String)this.instantTime, (StoragePath)this.path, (HoodieStorage)this.hoodieTable.getStorage(), (HoodieConfig)this.config, (Schema)this.writeSchemaWithMetaFields, (TaskContextSupplier)this.taskContextSupplier, (HoodieRecord.HoodieRecordType)this.config.getRecordMerger().getRecordType());
    }

    public HoodieCreateHandle(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, String partitionPath, String fileId, Map<String, HoodieRecord<T>> recordMap, TaskContextSupplier taskContextSupplier) {
        this(config, instantTime, hoodieTable, partitionPath, fileId, taskContextSupplier, true);
        this.recordMap = recordMap;
        this.useWriterSchema = true;
    }
}

