/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.io.FileGroupReaderBasedMergeHandle;
import org.apache.hudi.io.HoodieMergeHandle;
import org.apache.hudi.io.HoodieMergeHandleWithChangeLog;
import org.apache.hudi.io.HoodieSortedMergeHandle;
import org.apache.hudi.io.HoodieSortedMergeHandleWithChangeLog;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.table.HoodieTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieMergeHandleFactory {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieMergeHandleFactory.class);

    public static <T, I, K, O> HoodieMergeHandle<T, I, K, O> create(WriteOperationType operationType, HoodieWriteConfig writeConfig, String instantTime, HoodieTable<T, I, K, O> table, Iterator<HoodieRecord<T>> recordItr, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier, Option<BaseKeyGenerator> keyGeneratorOpt) {
        boolean isFallbackEnabled = writeConfig.isMergeHandleFallbackEnabled();
        Pair<String, String> mergeHandleClasses = HoodieMergeHandleFactory.getMergeHandleClassesWrite(operationType, writeConfig, table);
        String logContext = String.format("for fileId %s and partition path %s at commit %s", fileId, partitionPath, instantTime);
        LOG.info("Create HoodieMergeHandle implementation {} {}", mergeHandleClasses.getLeft(), (Object)logContext);
        Class[] constructorParamTypes = new Class[]{HoodieWriteConfig.class, String.class, HoodieTable.class, Iterator.class, String.class, String.class, TaskContextSupplier.class, Option.class};
        return HoodieMergeHandleFactory.instantiateMergeHandle(isFallbackEnabled, (String)mergeHandleClasses.getLeft(), (String)mergeHandleClasses.getRight(), logContext, constructorParamTypes, new Object[]{writeConfig, instantTime, table, recordItr, partitionPath, fileId, taskContextSupplier, keyGeneratorOpt});
    }

    public static <T, I, K, O> HoodieMergeHandle<T, I, K, O> create(HoodieWriteConfig writeConfig, String instantTime, HoodieTable<T, I, K, O> table, Map<String, HoodieRecord<T>> keyToNewRecords, String partitionPath, String fileId, HoodieBaseFile dataFileToBeMerged, TaskContextSupplier taskContextSupplier, Option<BaseKeyGenerator> keyGeneratorOpt) {
        boolean isFallbackEnabled = writeConfig.isMergeHandleFallbackEnabled();
        Pair<String, String> mergeHandleClasses = HoodieMergeHandleFactory.getMergeHandleClassesCompaction(writeConfig, table);
        String logContext = String.format("for fileId %s and partitionPath %s at commit %s", fileId, partitionPath, instantTime);
        LOG.info("Create HoodieMergeHandle implementation {} {}", mergeHandleClasses.getLeft(), (Object)logContext);
        Class[] constructorParamTypes = new Class[]{HoodieWriteConfig.class, String.class, HoodieTable.class, Map.class, String.class, String.class, HoodieBaseFile.class, TaskContextSupplier.class, Option.class};
        return HoodieMergeHandleFactory.instantiateMergeHandle(isFallbackEnabled, (String)mergeHandleClasses.getLeft(), (String)mergeHandleClasses.getRight(), logContext, constructorParamTypes, new Object[]{writeConfig, instantTime, table, keyToNewRecords, partitionPath, fileId, dataFileToBeMerged, taskContextSupplier, keyGeneratorOpt});
    }

    public static <T, I, K, O> HoodieMergeHandle<T, I, K, O> create(HoodieWriteConfig config, String instantTime, HoodieTable<T, I, K, O> hoodieTable, CompactionOperation operation, TaskContextSupplier taskContextSupplier, HoodieReaderContext<T> readerContext, String maxInstantTime, HoodieRecord.HoodieRecordType recordType) {
        boolean isFallbackEnabled = config.isMergeHandleFallbackEnabled();
        String mergeHandleClass = config.getCompactionMergeHandleClassName();
        String logContext = String.format("for fileId %s and partitionPath %s at commit %s", operation.getFileId(), operation.getPartitionPath(), instantTime);
        LOG.info("Create HoodieMergeHandle implementation {} {}", (Object)mergeHandleClass, (Object)logContext);
        Class[] constructorParamTypes = new Class[]{HoodieWriteConfig.class, String.class, HoodieTable.class, CompactionOperation.class, TaskContextSupplier.class, HoodieReaderContext.class, String.class, HoodieRecord.HoodieRecordType.class};
        return HoodieMergeHandleFactory.instantiateMergeHandle(isFallbackEnabled, mergeHandleClass, (String)HoodieWriteConfig.COMPACT_MERGE_HANDLE_CLASS_NAME.defaultValue(), logContext, constructorParamTypes, new Object[]{config, instantTime, hoodieTable, operation, taskContextSupplier, readerContext, maxInstantTime, recordType});
    }

    private static <T, I, K, O> HoodieMergeHandle<T, I, K, O> instantiateMergeHandle(boolean isFallbackEnabled, String primaryClass, String fallbackClass, String logContext, Class<?>[] constructorParamTypes, Object ... initargs) {
        try {
            return (HoodieMergeHandle)ReflectionUtils.loadClass((String)primaryClass, (Class[])constructorParamTypes, (Object[])initargs);
        }
        catch (Throwable e1) {
            if (isFallbackEnabled && fallbackClass != null && !Objects.equals(primaryClass, fallbackClass)) {
                try {
                    LOG.warn("HoodieMergeHandle implementation {} failed, now creating fallback implementation {} {}", new Object[]{primaryClass, fallbackClass, logContext});
                    return (HoodieMergeHandle)ReflectionUtils.loadClass((String)fallbackClass, (Class[])constructorParamTypes, (Object[])initargs);
                }
                catch (Throwable e2) {
                    throw new HoodieException("Could not instantiate the fallback HoodieMergeHandle implementation: " + fallbackClass, e2);
                }
            }
            throw new HoodieException("Could not instantiate the HoodieMergeHandle implementation: " + primaryClass, e1);
        }
    }

    @VisibleForTesting
    static Pair<String, String> getMergeHandleClassesWrite(WriteOperationType operationType, HoodieWriteConfig writeConfig, HoodieTable table) {
        String mergeHandleClass;
        String fallbackMergeHandleClass = null;
        if (table.requireSortedRecords()) {
            mergeHandleClass = table.getMetaClient().getTableConfig().isCDCEnabled() ? HoodieSortedMergeHandleWithChangeLog.class.getName() : HoodieSortedMergeHandle.class.getName();
        } else if (!WriteOperationType.isChangingRecords((WriteOperationType)operationType) && writeConfig.allowDuplicateInserts()) {
            mergeHandleClass = writeConfig.getConcatHandleClassName();
            if (!mergeHandleClass.equals(HoodieWriteConfig.CONCAT_HANDLE_CLASS_NAME.defaultValue())) {
                fallbackMergeHandleClass = (String)HoodieWriteConfig.CONCAT_HANDLE_CLASS_NAME.defaultValue();
            }
        } else if (table.getMetaClient().getTableConfig().isCDCEnabled()) {
            if (writeConfig.getMergeHandleClassName().equals(FileGroupReaderBasedMergeHandle.class.getName())) {
                mergeHandleClass = writeConfig.getMergeHandleClassName();
                if (!mergeHandleClass.equals(HoodieWriteConfig.MERGE_HANDLE_CLASS_NAME.defaultValue())) {
                    fallbackMergeHandleClass = (String)HoodieWriteConfig.MERGE_HANDLE_CLASS_NAME.defaultValue();
                }
            } else {
                mergeHandleClass = HoodieMergeHandleWithChangeLog.class.getName();
            }
        } else {
            mergeHandleClass = writeConfig.getMergeHandleClassName();
            if (!mergeHandleClass.equals(HoodieWriteConfig.MERGE_HANDLE_CLASS_NAME.defaultValue())) {
                fallbackMergeHandleClass = (String)HoodieWriteConfig.MERGE_HANDLE_CLASS_NAME.defaultValue();
            }
        }
        return Pair.of((Object)mergeHandleClass, fallbackMergeHandleClass);
    }

    @VisibleForTesting
    static Pair<String, String> getMergeHandleClassesCompaction(HoodieWriteConfig writeConfig, HoodieTable table) {
        String mergeHandleClass;
        String fallbackMergeHandleClass = null;
        if (table.requireSortedRecords()) {
            mergeHandleClass = HoodieSortedMergeHandle.class.getName();
        } else if (table.getMetaClient().getTableConfig().isCDCEnabled() && writeConfig.isYieldingPureLogForMor()) {
            mergeHandleClass = HoodieMergeHandleWithChangeLog.class.getName();
        } else {
            mergeHandleClass = writeConfig.getMergeHandleClassName();
            if (!mergeHandleClass.equals(HoodieWriteConfig.MERGE_HANDLE_CLASS_NAME.defaultValue())) {
                fallbackMergeHandleClass = (String)HoodieWriteConfig.MERGE_HANDLE_CLASS_NAME.defaultValue();
            }
        }
        return Pair.of((Object)mergeHandleClass, fallbackMergeHandleClass);
    }
}

