/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.avro.AvroSchemaCache;
import org.apache.hudi.avro.AvroSchemaUtils;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieAvroIndexedRecord;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.log.HoodieLogFormat;
import org.apache.hudi.common.table.log.LogFileCreationCallback;
import org.apache.hudi.common.table.read.DeleteContext;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.HoodieIOHandle;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.marker.WriteMarkers;
import org.apache.hudi.table.marker.WriteMarkersFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HoodieWriteHandle<T, I, K, O>
extends HoodieIOHandle<T, I, K, O> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieWriteHandle.class);
    protected final Schema writeSchema;
    protected final Schema writeSchemaWithMetaFields;
    protected final HoodieRecordMerger recordMerger;
    protected final DeleteContext deleteContext;
    protected HoodieTimer timer;
    protected WriteStatus writeStatus;
    protected HoodieRecordLocation newRecordLocation;
    protected final String partitionPath;
    protected final String fileId;
    protected final String writeToken;
    protected final TaskContextSupplier taskContextSupplier;
    protected final boolean schemaOnReadEnabled;
    protected final boolean preserveMetadata;
    protected final boolean isSecondaryIndexStatsStreamingWritesEnabled;
    protected List<HoodieIndexDefinition> secondaryIndexDefns = Collections.emptyList();
    private boolean closed = false;
    protected boolean isTrackingEventTimeWatermark;
    protected boolean keepConsistentLogicalTimestamp;
    protected String eventTimeFieldName;

    public HoodieWriteHandle(HoodieWriteConfig config, String instantTime, String partitionPath, String fileId, HoodieTable<T, I, K, O> hoodieTable, TaskContextSupplier taskContextSupplier, boolean preserveMetadata) {
        this(config, instantTime, partitionPath, fileId, hoodieTable, (Option<Schema>)Option.empty(), taskContextSupplier, preserveMetadata);
    }

    protected HoodieWriteHandle(HoodieWriteConfig config, String instantTime, String partitionPath, String fileId, HoodieTable<T, I, K, O> hoodieTable, Option<Schema> overriddenSchema, TaskContextSupplier taskContextSupplier, boolean preserveMetadata) {
        super(config, (Option<String>)Option.of((Object)instantTime), hoodieTable);
        this.partitionPath = partitionPath;
        this.fileId = fileId;
        this.writeSchema = AvroSchemaCache.intern((Schema)((Schema)overriddenSchema.orElseGet(() -> HoodieWriteHandle.getWriteSchema(config))));
        this.writeSchemaWithMetaFields = AvroSchemaCache.intern((Schema)HoodieAvroUtils.addMetadataFields((Schema)this.writeSchema, (boolean)config.allowOperationMetadataField()));
        this.timer = HoodieTimer.start();
        this.newRecordLocation = new HoodieRecordLocation(instantTime, fileId);
        this.taskContextSupplier = taskContextSupplier;
        this.writeToken = this.makeWriteToken();
        this.schemaOnReadEnabled = !StringUtils.isNullOrEmpty((String)hoodieTable.getConfig().getInternalSchema());
        this.preserveMetadata = preserveMetadata;
        this.recordMerger = config.getRecordMerger();
        this.writeStatus = (WriteStatus)ReflectionUtils.loadClass((String)config.getWriteStatusClassName(), (Object[])new Object[]{hoodieTable.shouldTrackSuccessRecords(), config.getWriteStatusFailureFraction(), hoodieTable.isMetadataTable()});
        boolean isMetadataStreamingWritesEnabled = config.isMetadataStreamingWritesEnabled(hoodieTable.getMetaClient().getTableConfig().getTableVersion());
        if (isMetadataStreamingWritesEnabled) {
            this.initSecondaryIndexStats(preserveMetadata);
            this.isSecondaryIndexStatsStreamingWritesEnabled = !this.secondaryIndexDefns.isEmpty();
        } else {
            this.isSecondaryIndexStatsStreamingWritesEnabled = false;
        }
        this.eventTimeFieldName = ConfigUtils.getEventTimeFieldName((TypedProperties)config.getProps());
        this.isTrackingEventTimeWatermark = this.eventTimeFieldName != null && hoodieTable.getMetaClient().getTableConfig().getRecordMergeMode() == RecordMergeMode.EVENT_TIME_ORDERING && ConfigUtils.isTrackingEventTimeWatermark((TypedProperties)config.getProps());
        this.keepConsistentLogicalTimestamp = this.isTrackingEventTimeWatermark && ConfigUtils.shouldKeepConsistentLogicalTimestamp((TypedProperties)config.getProps());
        TypedProperties mergeProps = ConfigUtils.getMergeProps((TypedProperties)config.getProps(), (HoodieTableConfig)hoodieTable.getMetaClient().getTableConfig());
        Schema deleteContextSchema = preserveMetadata ? this.writeSchemaWithMetaFields : this.writeSchema;
        this.deleteContext = new DeleteContext((Properties)mergeProps, deleteContextSchema).withReaderSchema(deleteContextSchema);
    }

    private void initSecondaryIndexStats(boolean preserveMetadata) {
        if (!preserveMetadata) {
            this.secondaryIndexDefns = ((Collection)this.hoodieTable.getMetaClient().getIndexMetadata().map(indexMetadata -> indexMetadata.getIndexDefinitions().values()).orElse(Collections.emptyList())).stream().filter(indexDef -> indexDef.getIndexName().startsWith("secondary_index_")).collect(Collectors.toList());
            this.secondaryIndexDefns.forEach(def -> this.writeStatus.getIndexStats().initSecondaryIndexStats(def.getIndexName()));
        }
    }

    private String makeWriteToken() {
        return FSUtils.makeWriteToken((int)this.getPartitionId(), (int)this.getStageId(), (long)this.getAttemptId());
    }

    public StoragePath makeNewPath(String partitionPath) {
        StoragePath path = FSUtils.constructAbsolutePath((String)this.config.getBasePath(), (String)partitionPath);
        try {
            if (!this.storage.exists(path)) {
                this.storage.createDirectory(path);
            }
        }
        catch (IOException e) {
            throw new HoodieIOException("Failed to make dir " + path, e);
        }
        return new StoragePath(path, FSUtils.makeBaseFileName((String)this.instantTime, (String)this.writeToken, (String)this.fileId, (String)this.hoodieTable.getBaseFileExtension()));
    }

    protected StoragePath makeNewFilePath(String partitionPath, String fileName) {
        String relativePath = new StoragePath((partitionPath.isEmpty() ? "" : partitionPath + "/") + fileName).toString();
        return new StoragePath(this.config.getBasePath(), relativePath);
    }

    protected void createMarkerFile(String partitionPath, String dataFileName) {
        WriteMarkersFactory.get(this.config.getMarkersType(), this.hoodieTable, this.instantTime).create(partitionPath, dataFileName, this.getIOType(), this.config, this.fileId, this.hoodieTable.getMetaClient().getActiveTimeline());
    }

    public Schema getWriterSchemaWithMetaFields() {
        return this.writeSchemaWithMetaFields;
    }

    public Schema getWriterSchema() {
        return this.writeSchema;
    }

    public boolean canWrite(HoodieRecord record) {
        return false;
    }

    boolean layoutControlsNumFiles() {
        return this.hoodieTable.getStorageLayout().determinesNumFileGroups();
    }

    protected void doWrite(HoodieRecord record, Schema schema, TypedProperties props) {
    }

    public void write(HoodieRecord record, Schema schema, TypedProperties props) {
        this.doWrite(record, schema, props);
    }

    protected boolean isClosed() {
        return this.closed;
    }

    protected void markClosed() {
        this.closed = true;
    }

    public abstract List<WriteStatus> close();

    public List<WriteStatus> getWriteStatuses() {
        return Collections.singletonList(this.writeStatus);
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public abstract IOType getIOType();

    @Override
    public HoodieStorage getStorage() {
        return this.hoodieTable.getStorage();
    }

    public HoodieWriteConfig getConfig() {
        return this.config;
    }

    public HoodieTableMetaClient getHoodieTableMetaClient() {
        return this.hoodieTable.getMetaClient();
    }

    public String getFileId() {
        return this.fileId;
    }

    protected int getPartitionId() {
        return (Integer)this.taskContextSupplier.getPartitionIdSupplier().get();
    }

    protected int getStageId() {
        return (Integer)this.taskContextSupplier.getStageIdSupplier().get();
    }

    protected long getAttemptId() {
        return (Long)this.taskContextSupplier.getAttemptIdSupplier().get();
    }

    private static Schema getWriteSchema(HoodieWriteConfig config) {
        return new Schema.Parser().parse(config.getWriteSchema());
    }

    protected HoodieLogFormat.Writer createLogWriter(String instantTime, Option<FileSlice> fileSliceOpt) {
        return this.createLogWriter(instantTime, null, fileSliceOpt);
    }

    protected HoodieLogFormat.Writer createLogWriter(String instantTime, String fileSuffix, Option<FileSlice> fileSliceOpt) {
        try {
            if (this.config.getWriteVersion().greaterThanOrEquals(HoodieTableVersion.EIGHT)) {
                return HoodieLogFormat.newWriterBuilder().onParentPath(FSUtils.constructAbsolutePath((StoragePath)this.hoodieTable.getMetaClient().getBasePath(), (String)this.partitionPath)).withFileId(this.fileId).withInstantTime(instantTime).withFileSize(0L).withSizeThreshold(this.config.getLogFileMaxSize()).withStorage(this.storage).withLogWriteToken(this.writeToken).withFileCreationCallback(this.getLogCreationCallback()).withTableVersion(this.config.getWriteVersion()).withSuffix(fileSuffix).withFileExtension(".log").build();
            }
            Option latestLogFile = fileSliceOpt.isPresent() ? ((FileSlice)fileSliceOpt.get()).getLatestLogFile() : Option.empty();
            return HoodieLogFormat.newWriterBuilder().onParentPath(FSUtils.constructAbsolutePath((StoragePath)this.hoodieTable.getMetaClient().getBasePath(), (String)this.partitionPath)).withFileId(this.fileId).withInstantTime(instantTime).withLogVersion(((Integer)latestLogFile.map(HoodieLogFile::getLogVersion).orElse((Object)HoodieLogFile.LOGFILE_BASE_VERSION)).intValue()).withFileSize(((Long)latestLogFile.map(HoodieLogFile::getFileSize).orElse((Object)0L)).longValue()).withSizeThreshold(this.config.getLogFileMaxSize()).withStorage(this.storage).withLogWriteToken((String)latestLogFile.map(HoodieLogFile::getLogWriteToken).orElse((Object)this.writeToken)).withSuffix(fileSuffix).withFileCreationCallback(this.getLogCreationCallback()).withFileExtension(".log").build();
        }
        catch (IOException e) {
            throw new HoodieException("Creating logger writer with fileId: " + this.fileId + ", delta commit time: " + instantTime + ", file suffix: " + fileSuffix + " error");
        }
    }

    protected LogFileCreationCallback getLogCreationCallback() {
        return new LogFileCreationCallback(){

            public boolean preFileCreation(HoodieLogFile logFile) {
                WriteMarkers writeMarkers = WriteMarkersFactory.get(HoodieWriteHandle.this.config.getMarkersType(), HoodieWriteHandle.this.hoodieTable, HoodieWriteHandle.this.instantTime);
                return writeMarkers.createLogMarkerIfNotExists(HoodieWriteHandle.this.partitionPath, logFile.getFileName(), HoodieWriteHandle.this.config, HoodieWriteHandle.this.fileId, HoodieWriteHandle.this.hoodieTable.getMetaClient().getActiveTimeline()).isPresent();
            }
        };
    }

    protected static Option<IndexedRecord> toAvroRecord(HoodieRecord record, Schema writerSchema, TypedProperties props) {
        try {
            return record.toIndexedRecord(writerSchema, (Properties)props).map(HoodieAvroIndexedRecord::getData);
        }
        catch (IOException e) {
            LOG.error("Failed to convert to IndexedRecord", (Throwable)e);
            return Option.empty();
        }
    }

    protected Option<Map<String, String>> getRecordMetadata(HoodieRecord record, Schema schema, Properties props) {
        Object eventTime;
        Option recordMetadata = record.getMetadata();
        if (this.isTrackingEventTimeWatermark && (eventTime = record.getColumnValueAsJava(schema, this.eventTimeFieldName, props)) != null) {
            Option field = AvroSchemaUtils.findNestedField((Schema)schema, (String)this.eventTimeFieldName);
            eventTime = record.convertColumnValueForLogicalType(((Schema.Field)field.get()).schema(), eventTime, this.keepConsistentLogicalTimestamp);
            Map metadata = (Map)recordMetadata.orElse(new HashMap());
            metadata.put("metadata.event_time.key", String.valueOf(eventTime));
            return Option.of((Object)metadata);
        }
        return recordMetadata;
    }
}

