/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieMemoryConfig;
import org.apache.hudi.common.engine.EngineProperty;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.io.HoodieMergeHandle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOUtils {
    private static final Logger LOG = LoggerFactory.getLogger(IOUtils.class);

    public static long getMaxMemoryAllowedForMerge(TaskContextSupplier context, String maxMemoryFraction) {
        Option totalMemoryOpt = context.getProperty(EngineProperty.TOTAL_MEMORY_AVAILABLE);
        Option memoryFractionOpt = context.getProperty(EngineProperty.MEMORY_FRACTION_IN_USE);
        Option totalCoresOpt = context.getProperty(EngineProperty.TOTAL_CORES_PER_EXECUTOR);
        if (totalMemoryOpt.isPresent() && memoryFractionOpt.isPresent() && totalCoresOpt.isPresent()) {
            long executorMemoryInBytes = Long.parseLong((String)totalMemoryOpt.get());
            double memoryFraction = Double.parseDouble((String)memoryFractionOpt.get());
            double maxMemoryFractionForMerge = Double.parseDouble(maxMemoryFraction);
            long executorCores = Long.parseLong((String)totalCoresOpt.get());
            Option singleTaskCoresOpt = context.getProperty(EngineProperty.SINGLE_TASK_CORES);
            long executorTaskNum = executorCores;
            if (singleTaskCoresOpt.isPresent()) {
                executorTaskNum = executorCores / Long.parseLong((String)singleTaskCoresOpt.get());
            }
            double userAvailableMemory = (double)executorMemoryInBytes * (1.0 - memoryFraction) / (double)executorTaskNum;
            long maxMemoryForMerge = (long)Math.floor(userAvailableMemory * maxMemoryFractionForMerge);
            return Math.max(0x6400000L, maxMemoryForMerge);
        }
        return 0x40000000L;
    }

    public static long getMaxMemoryPerPartitionMerge(TaskContextSupplier context, HoodieConfig hoodieConfig) {
        if (hoodieConfig.contains(HoodieMemoryConfig.MAX_MEMORY_FOR_MERGE)) {
            return hoodieConfig.getLong(HoodieMemoryConfig.MAX_MEMORY_FOR_MERGE);
        }
        String fraction = hoodieConfig.getStringOrDefault(HoodieMemoryConfig.MAX_MEMORY_FRACTION_FOR_MERGE);
        return IOUtils.getMaxMemoryAllowedForMerge(context, fraction);
    }

    public static long getMaxMemoryPerCompaction(TaskContextSupplier context, HoodieConfig hoodieConfig) {
        if (hoodieConfig.contains(HoodieMemoryConfig.MAX_MEMORY_FOR_COMPACTION)) {
            return hoodieConfig.getLong(HoodieMemoryConfig.MAX_MEMORY_FOR_COMPACTION);
        }
        String fraction = hoodieConfig.getStringOrDefault(HoodieMemoryConfig.MAX_MEMORY_FRACTION_FOR_COMPACTION);
        return IOUtils.getMaxMemoryAllowedForMerge(context, fraction);
    }

    public static long getMaxMemoryPerCompaction(TaskContextSupplier context, Map<String, String> options) {
        if (options.containsKey(HoodieMemoryConfig.MAX_MEMORY_FOR_COMPACTION.key())) {
            return Long.parseLong(options.get(HoodieMemoryConfig.MAX_MEMORY_FOR_COMPACTION.key()));
        }
        String fraction = options.getOrDefault(HoodieMemoryConfig.MAX_MEMORY_FRACTION_FOR_COMPACTION.key(), (String)HoodieMemoryConfig.MAX_MEMORY_FRACTION_FOR_COMPACTION.defaultValue());
        return IOUtils.getMaxMemoryAllowedForMerge(context, fraction);
    }

    public static Iterator<List<WriteStatus>> runMerge(HoodieMergeHandle<?, ?, ?, ?> mergeHandle, String instantTime, String fileId) throws IOException {
        if (mergeHandle.getOldFilePath() == null) {
            throw new HoodieUpsertException("Error in finding the old file path at commit " + instantTime + " for fileId: " + fileId);
        }
        mergeHandle.doMerge();
        if (mergeHandle.getPartitionPath() == null) {
            LOG.info("Upsert Handle has partition path as null " + mergeHandle.getOldFilePath() + ", " + mergeHandle.getWriteStatuses());
        }
        return Collections.singletonList(mergeHandle.close()).iterator();
    }
}

