/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.metadata.SecondaryIndexRecordGenerationUtils;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;

public class SecondaryIndexStreamingTracker {
    static void trackSecondaryIndexStats(String partitionPath, String fileId, Option<FileSlice> fileSliceOpt, List<String> newLogFiles, WriteStatus status, HoodieTable hoodieTable, List<HoodieIndexDefinition> secondaryIndexDefns, HoodieWriteConfig config, String instantTime, Schema writeSchemaWithMetaFields) {
        HoodieReaderContext readerContext = hoodieTable.getContext().getReaderContextFactory(hoodieTable.getMetaClient()).getContext();
        secondaryIndexDefns.forEach(def -> {
            Map<String, String> recordKeyToSecondaryKeyForCurrentFileSlice;
            Map recordKeyToSecondaryKeyForPreviousFileSlice = (Map)fileSliceOpt.map(fileSlice -> {
                try {
                    return SecondaryIndexRecordGenerationUtils.getRecordKeyToSecondaryKey(hoodieTable.getMetaClient(), readerContext, fileSlice, writeSchemaWithMetaFields, def, instantTime, config.getProps(), false);
                }
                catch (IOException e) {
                    throw new HoodieIOException("Failed to generate secondary index stats ", e);
                }
            }).orElse(Collections.emptyMap());
            FileSlice latestIncludingInflight = (FileSlice)fileSliceOpt.orElse((Object)new FileSlice(new HoodieFileGroupId(partitionPath, fileId), instantTime));
            newLogFiles.stream().forEach(logFile -> latestIncludingInflight.addLogFile(new HoodieLogFile(new StoragePath(config.getBasePath(), logFile))));
            try {
                recordKeyToSecondaryKeyForCurrentFileSlice = SecondaryIndexRecordGenerationUtils.getRecordKeyToSecondaryKey(hoodieTable.getMetaClient(), readerContext, latestIncludingInflight, writeSchemaWithMetaFields, def, instantTime, config.getProps(), true);
            }
            catch (IOException e) {
                throw new HoodieIOException("Failed to generate secondary index stats ", e);
            }
            String indexName = def.getIndexName();
            recordKeyToSecondaryKeyForCurrentFileSlice.forEach((recordKey, secondaryKey) -> {
                if (!recordKeyToSecondaryKeyForPreviousFileSlice.containsKey(recordKey)) {
                    status.getIndexStats().addSecondaryIndexStats(indexName, (String)recordKey, (String)secondaryKey, false);
                } else {
                    String previousSecondaryKey = (String)recordKeyToSecondaryKeyForPreviousFileSlice.get(recordKey);
                    if (!Objects.equals(previousSecondaryKey, secondaryKey)) {
                        status.getIndexStats().addSecondaryIndexStats(indexName, (String)recordKey, previousSecondaryKey, true);
                        status.getIndexStats().addSecondaryIndexStats(indexName, (String)recordKey, (String)secondaryKey, false);
                    }
                }
            });
            Map<String, String> finalRecordKeyToSecondaryKeyForCurrentFileSlice = recordKeyToSecondaryKeyForCurrentFileSlice;
            recordKeyToSecondaryKeyForPreviousFileSlice.forEach((recordKey, secondaryKey) -> {
                if (!finalRecordKeyToSecondaryKeyForCurrentFileSlice.containsKey(recordKey)) {
                    status.getIndexStats().addSecondaryIndexStats(indexName, (String)recordKey, (String)secondaryKey, true);
                }
            });
        });
    }

    static void trackSecondaryIndexStats(HoodieRecord record, WriteStatus writeStatus, Schema writeSchemaWithMetaFields, List<HoodieIndexDefinition> secondaryIndexDefns, HoodieWriteConfig config) {
        secondaryIndexDefns.forEach(def -> {
            Object secondaryKey = record.getColumnValueAsJava(writeSchemaWithMetaFields, def.getSourceFieldsKey(), (Properties)config.getProps());
            SecondaryIndexStreamingTracker.addSecondaryIndexStat(writeStatus, def.getIndexName(), record.getRecordKey(), secondaryKey, false);
        });
    }

    static <T> void trackSecondaryIndexStats(@Nullable HoodieKey hoodieKey, HoodieRecord combinedRecord, @Nullable HoodieRecord<T> oldRecord, boolean isDelete, WriteStatus writeStatus, Schema writeSchemaWithMetaFields, Supplier<Schema> newSchemaSupplier, List<HoodieIndexDefinition> secondaryIndexDefns, Option<BaseKeyGenerator> keyGeneratorOpt, HoodieWriteConfig config) {
        secondaryIndexDefns.forEach(def -> {
            boolean shouldUpdate;
            String secondaryIndexSourceField = def.getSourceFieldsKey();
            boolean hasOldValue = oldRecord != null;
            Object oldSecondaryKey = null;
            if (hasOldValue) {
                oldSecondaryKey = oldRecord.getColumnValueAsJava(writeSchemaWithMetaFields, secondaryIndexSourceField, (Properties)config.getProps());
            }
            boolean hasNewValue = false;
            Object newSecondaryKey = null;
            if (!isDelete) {
                Schema newSchema = (Schema)newSchemaSupplier.get();
                newSecondaryKey = combinedRecord.getColumnValueAsJava(newSchema, secondaryIndexSourceField, (Properties)config.getProps());
                hasNewValue = true;
            }
            if (shouldUpdate = !hasOldValue && !hasNewValue ? false : (hasOldValue && hasNewValue ? !Objects.equals(oldSecondaryKey, newSecondaryKey) : true)) {
                String recordKey = (String)Option.ofNullable((Object)hoodieKey).map(HoodieKey::getRecordKey).or(() -> Option.ofNullable((Object)oldRecord).map(rec -> rec.getRecordKey(writeSchemaWithMetaFields, keyGeneratorOpt))).orElseGet(() -> ((HoodieRecord)combinedRecord).getRecordKey());
                if (hasOldValue) {
                    SecondaryIndexStreamingTracker.addSecondaryIndexStat(writeStatus, def.getIndexName(), recordKey, oldSecondaryKey, true);
                }
                if (hasNewValue) {
                    SecondaryIndexStreamingTracker.addSecondaryIndexStat(writeStatus, def.getIndexName(), recordKey, newSecondaryKey, false);
                }
            }
        });
    }

    static <T> void trackSecondaryIndexStats(HoodieKey hoodieKey, Option<BufferedRecord<T>> combinedRecordOpt, @Nullable BufferedRecord<T> oldRecord, boolean isDelete, WriteStatus writeStatus, List<HoodieIndexDefinition> secondaryIndexDefns, RecordContext<T> recordContext) {
        secondaryIndexDefns.forEach(def -> {
            boolean shouldUpdate;
            String secondaryIndexSourceField = def.getSourceFieldsKey();
            boolean hasOldValue = oldRecord != null;
            String oldSecondaryKey = null;
            if (hasOldValue) {
                Schema schema = recordContext.decodeAvroSchema((Object)oldRecord.getSchemaId());
                oldSecondaryKey = recordContext.getTypeConverter().castToString(recordContext.getValue(oldRecord.getRecord(), schema, secondaryIndexSourceField));
            }
            boolean hasNewValue = false;
            String newSecondaryKey = null;
            if (combinedRecordOpt.isPresent() && !isDelete) {
                Schema schema = recordContext.decodeAvroSchema((Object)((BufferedRecord)combinedRecordOpt.get()).getSchemaId());
                newSecondaryKey = recordContext.getTypeConverter().castToString(recordContext.getValue(((BufferedRecord)combinedRecordOpt.get()).getRecord(), schema, secondaryIndexSourceField));
                hasNewValue = true;
            }
            if (shouldUpdate = !hasOldValue && !hasNewValue ? false : (hasOldValue && hasNewValue ? !Objects.equals(oldSecondaryKey, newSecondaryKey) : true)) {
                String recordKey = hoodieKey.getRecordKey();
                if (hasOldValue) {
                    SecondaryIndexStreamingTracker.addSecondaryIndexStat(writeStatus, def.getIndexName(), recordKey, oldSecondaryKey, true);
                }
                if (hasNewValue) {
                    SecondaryIndexStreamingTracker.addSecondaryIndexStat(writeStatus, def.getIndexName(), recordKey, newSecondaryKey, false);
                }
            }
        });
    }

    private static void addSecondaryIndexStat(WriteStatus writeStatus, String secondaryIndexPartitionPath, String recordKey, Object secKey, boolean isDeleted) {
        String secKeyStr = secKey == null ? null : secKey.toString();
        writeStatus.getIndexStats().addSecondaryIndexStats(secondaryIndexPartitionPath, recordKey, secKeyStr, isDeleted);
    }
}

