/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.function.SerializableFunctionUnchecked;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;

public class ComplexAvroKeyGenerator
extends BaseKeyGenerator {
    public static final String DEFAULT_RECORD_KEY_SEPARATOR = ":";
    private final SerializableFunctionUnchecked<GenericRecord, String> recordKeyFunction;

    public ComplexAvroKeyGenerator(TypedProperties props) {
        super(props);
        this.recordKeyFields = KeyGenUtils.getRecordKeyFields(props);
        this.partitionPathFields = Arrays.stream(props.getString(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key()).split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList());
        this.recordKeyFunction = this.getRecordKeyFunc(KeyGenUtils.encodeSingleKeyFieldNameForComplexKeyGen(props));
    }

    public String getRecordKey(GenericRecord record) {
        return (String)this.recordKeyFunction.apply((Object)record);
    }

    public String getPartitionPath(GenericRecord record) {
        return KeyGenUtils.getRecordPartitionPath(record, this.getPartitionPathFields(), this.hiveStylePartitioning, this.encodePartitionPath, this.isConsistentLogicalTimestampEnabled());
    }

    private SerializableFunctionUnchecked<GenericRecord, String> getRecordKeyFunc(boolean encodeSingleKeyFieldName) {
        if (this.getRecordKeyFieldNames().size() == 1) {
            if (encodeSingleKeyFieldName) {
                return (SerializableFunctionUnchecked & Serializable)record -> KeyGenUtils.getRecordKey(record, this.getRecordKeyFieldNames(), this.isConsistentLogicalTimestampEnabled());
            }
            return (SerializableFunctionUnchecked & Serializable)record -> KeyGenUtils.getRecordKey(record, (String)this.getRecordKeyFieldNames().get(0), this.isConsistentLogicalTimestampEnabled());
        }
        return (SerializableFunctionUnchecked & Serializable)record -> KeyGenUtils.getRecordKey(record, this.getRecordKeyFieldNames(), this.isConsistentLogicalTimestampEnabled());
    }
}

