/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.PartitionPathEncodeUtils;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieKeyException;
import org.apache.hudi.keygen.BaseKeyGenerator;
import org.apache.hudi.keygen.KeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.keygen.constant.KeyGeneratorType;
import org.apache.hudi.keygen.parser.BaseHoodieDateTimeParser;

public class KeyGenUtils {
    protected static final String HUDI_DEFAULT_PARTITION_PATH = "__HIVE_DEFAULT_PARTITION__";
    public static final String DEFAULT_PARTITION_PATH_SEPARATOR = "/";
    public static final String RECORD_KEY_GEN_PARTITION_ID_CONFIG = "_hoodie.record.key.gen.partition.id";
    public static final String RECORD_KEY_GEN_INSTANT_TIME_CONFIG = "_hoodie.record.key.gen.instant.time";

    public static KeyGeneratorType inferKeyGeneratorType(Option<String> recordsKeyFields, String partitionFields) {
        int numRecordKeyFields = (Integer)recordsKeyFields.map(fields -> fields.split(",").length).orElse((Object)0);
        KeyGeneratorType partitionKeyGeneratorType = KeyGenUtils.inferKeyGeneratorTypeFromPartitionFields(partitionFields);
        if (numRecordKeyFields <= 1) {
            return partitionKeyGeneratorType;
        }
        if (partitionKeyGeneratorType == KeyGeneratorType.SIMPLE) {
            return KeyGeneratorType.COMPLEX;
        }
        return partitionKeyGeneratorType;
    }

    static KeyGeneratorType inferKeyGeneratorTypeFromPartitionFields(String partitionFields) {
        if (!StringUtils.isNullOrEmpty((String)partitionFields)) {
            String[] partitonFields = partitionFields.split(",");
            if (partitonFields[0].contains(":")) {
                return KeyGeneratorType.CUSTOM;
            }
            if (partitonFields.length == 1) {
                return KeyGeneratorType.SIMPLE;
            }
            return KeyGeneratorType.COMPLEX;
        }
        return KeyGeneratorType.NON_PARTITION;
    }

    public static String getRecordKeyFromGenericRecord(GenericRecord genericRecord, Option<BaseKeyGenerator> keyGeneratorOpt) {
        return keyGeneratorOpt.isPresent() ? ((BaseKeyGenerator)keyGeneratorOpt.get()).getRecordKey(genericRecord) : genericRecord.get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
    }

    public static String getPartitionPathFromGenericRecord(GenericRecord genericRecord, Option<BaseKeyGenerator> keyGeneratorOpt) {
        return keyGeneratorOpt.isPresent() ? ((BaseKeyGenerator)keyGeneratorOpt.get()).getPartitionPath(genericRecord) : genericRecord.get(HoodieRecord.PARTITION_PATH_METADATA_FIELD).toString();
    }

    public static String[] extractRecordKeys(String recordKey) {
        return KeyGenUtils.extractRecordKeysByFields(recordKey, Collections.emptyList());
    }

    public static String[] extractRecordKeysByFields(String recordKey, List<String> fields) {
        String[] stringArray;
        if (!recordKey.contains(",") || !recordKey.contains(":")) {
            return new String[]{recordKey};
        }
        ArrayList<String> values = new ArrayList<String>();
        int processed = 0;
        while (processed < recordKey.length()) {
            int commaPosition;
            int keyValueSep1 = recordKey.indexOf(":", processed);
            String currentField = recordKey.substring(processed, keyValueSep1);
            int keyValueSep2 = recordKey.indexOf(":", keyValueSep1 + 1);
            if (fields.isEmpty() || fields.size() == 1 && fields.get(0).isEmpty() || fields.contains(currentField)) {
                String currentValue;
                if (keyValueSep2 < 0) {
                    currentValue = recordKey.substring(keyValueSep1 + 1);
                    processed = recordKey.length();
                } else {
                    commaPosition = recordKey.lastIndexOf(",", keyValueSep2);
                    while (commaPosition < keyValueSep1 && keyValueSep2 > 0) {
                        keyValueSep2 = recordKey.indexOf(":", keyValueSep2 + 1);
                        commaPosition = recordKey.lastIndexOf(",", keyValueSep2);
                    }
                    if (commaPosition > 0) {
                        currentValue = recordKey.substring(keyValueSep1 + 1, commaPosition);
                        processed = commaPosition + 1;
                    } else {
                        currentValue = recordKey.substring(keyValueSep1 + 1);
                        processed = recordKey.length();
                    }
                }
                if (currentValue.equals("__null__")) {
                    values.add(null);
                    continue;
                }
                if (currentValue.equals("__empty__")) {
                    values.add("");
                    continue;
                }
                values.add(currentValue);
                continue;
            }
            if (keyValueSep2 < 0) {
                processed = recordKey.length();
                continue;
            }
            commaPosition = recordKey.lastIndexOf(",", keyValueSep2);
            while (commaPosition < keyValueSep1) {
                keyValueSep2 = recordKey.indexOf(":", keyValueSep2 + 1);
                commaPosition = recordKey.lastIndexOf(",", keyValueSep2);
            }
            if (commaPosition < 0) {
                processed = recordKey.length();
                continue;
            }
            processed = commaPosition + 1;
        }
        if (values.isEmpty()) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = recordKey;
        } else {
            stringArray = values.toArray(new String[0]);
        }
        return stringArray;
    }

    public static String getRecordKey(GenericRecord record, List<String> recordKeyFields, boolean consistentLogicalTimestampEnabled) {
        BiFunction<String, Integer, String> valueFunction = (recordKeyField, index) -> {
            try {
                return HoodieAvroUtils.getNestedFieldValAsString((GenericRecord)record, (String)recordKeyField, (boolean)false, (boolean)consistentLogicalTimestampEnabled);
            }
            catch (HoodieException e) {
                throw new HoodieKeyException("Record key field '" + recordKeyField + "' does not exist in the input record");
            }
        };
        return KeyGenerator.constructRecordKey((String[])recordKeyFields.toArray(new String[0]), valueFunction);
    }

    public static String getRecordPartitionPath(GenericRecord record, List<String> partitionPathFields, boolean hiveStylePartitioning, boolean encodePartitionPath, boolean consistentLogicalTimestampEnabled) {
        if (partitionPathFields.isEmpty()) {
            return "";
        }
        StringBuilder partitionPath = new StringBuilder();
        for (int i = 0; i < partitionPathFields.size(); ++i) {
            String partitionPathField = partitionPathFields.get(i);
            String fieldVal = HoodieAvroUtils.getNestedFieldValAsString((GenericRecord)record, (String)partitionPathField, (boolean)true, (boolean)consistentLogicalTimestampEnabled);
            if (fieldVal == null || fieldVal.isEmpty()) {
                if (hiveStylePartitioning) {
                    partitionPath.append(partitionPathField).append("=");
                }
                partitionPath.append(HUDI_DEFAULT_PARTITION_PATH);
            } else {
                if (encodePartitionPath) {
                    fieldVal = PartitionPathEncodeUtils.escapePathName((String)fieldVal);
                }
                if (hiveStylePartitioning) {
                    partitionPath.append(partitionPathField).append("=");
                }
                partitionPath.append(fieldVal);
            }
            if (i == partitionPathFields.size() - 1) continue;
            partitionPath.append(DEFAULT_PARTITION_PATH_SEPARATOR);
        }
        return partitionPath.toString();
    }

    public static String getRecordKey(GenericRecord record, String recordKeyField, boolean consistentLogicalTimestampEnabled) {
        String recordKey = HoodieAvroUtils.getNestedFieldValAsString((GenericRecord)record, (String)recordKeyField, (boolean)true, (boolean)consistentLogicalTimestampEnabled);
        if (recordKey == null || recordKey.isEmpty()) {
            throw new HoodieKeyException("recordKey value: \"" + recordKey + "\" for field: \"" + recordKeyField + "\" cannot be null or empty.");
        }
        return recordKey;
    }

    public static String getPartitionPath(GenericRecord record, String partitionPathField, boolean hiveStylePartitioning, boolean encodePartitionPath, boolean consistentLogicalTimestampEnabled) {
        String partitionPath = HoodieAvroUtils.getNestedFieldValAsString((GenericRecord)record, (String)partitionPathField, (boolean)true, (boolean)consistentLogicalTimestampEnabled);
        if (partitionPath == null || partitionPath.isEmpty()) {
            partitionPath = HUDI_DEFAULT_PARTITION_PATH;
        }
        if (encodePartitionPath) {
            partitionPath = PartitionPathEncodeUtils.escapePathName((String)partitionPath);
        }
        if (hiveStylePartitioning) {
            partitionPath = partitionPathField + "=" + partitionPath;
        }
        return partitionPath;
    }

    public static BaseHoodieDateTimeParser createDateTimeParser(TypedProperties props, String parserClass) throws IOException {
        try {
            return (BaseHoodieDateTimeParser)ReflectionUtils.loadClass((String)parserClass, (Object[])new Object[]{props});
        }
        catch (Throwable e) {
            throw new IOException("Could not load date time parser class " + parserClass, e);
        }
    }

    public static KeyGenerator createKeyGeneratorByClassName(TypedProperties props) throws IOException {
        KeyGenerator keyGenerator = null;
        String keyGeneratorClass = props.getString(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), null);
        if (!StringUtils.isNullOrEmpty((String)keyGeneratorClass)) {
            try {
                keyGenerator = (KeyGenerator)ReflectionUtils.loadClass((String)keyGeneratorClass, (Object[])new Object[]{props});
            }
            catch (Throwable e) {
                throw new IOException("Could not load key generator class " + keyGeneratorClass, e);
            }
        }
        return keyGenerator;
    }

    public static List<String> getRecordKeyFields(TypedProperties props) {
        return (List)Option.ofNullable((Object)props.getString(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), null)).map(recordKeyConfigValue -> Arrays.stream(recordKeyConfigValue.split(",")).map(String::trim).filter(s -> !s.isEmpty()).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public static boolean isAutoGeneratedRecordKeysEnabled(TypedProperties props) {
        return !props.containsKey((Object)KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()) || props.getProperty(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key()).equals("");
    }

    public static boolean isComplexKeyGeneratorWithSingleRecordKeyField(HoodieTableConfig tableConfig) {
        Option recordKeyFields = tableConfig.getRecordKeyFields();
        return KeyGeneratorType.isComplexKeyGenerator((HoodieConfig)tableConfig) && recordKeyFields.isPresent() && ((String[])recordKeyFields.get()).length == 1;
    }

    public static String getComplexKeygenErrorMessage(String operation) {
        return "This table uses the complex key generator with a single record key field. If the table is written with Hudi 0.14.1, 0.15.0, 1.0.0, 1.0.1, or 1.0.2 release before, the table may potentially contain duplicates due to a breaking change in the key encoding in the _hoodie_record_key meta field (HUDI-7001) which is crucial for upserts. Please take action based on the details on the deployment guide (https://hudi.apache.org/docs/deployment#complex-key-generator) before resuming the " + operation + " to the this table. If you're certain that the table is not affected by the key encoding change, set `hoodie.write.complex.keygen.validation.enable=false` to skip this validation.";
    }

    public static boolean encodeSingleKeyFieldNameForComplexKeyGen(TypedProperties props) {
        int tableVersionCode = ConfigUtils.getIntWithAltKeys((Properties)props, HoodieWriteConfig.WRITE_TABLE_VERSION);
        HoodieTableVersion tableVersion = HoodieTableVersion.fromVersionCode((int)tableVersionCode);
        return tableVersion.greaterThanOrEquals(HoodieTableVersion.NINE) || !ConfigUtils.getBooleanWithAltKeys((Properties)props, HoodieWriteConfig.COMPLEX_KEYGEN_NEW_ENCODING);
    }

    public static boolean mayUseNewEncodingForComplexKeyGen(HoodieTableConfig tableConfig) {
        return tableConfig.getTableVersion().lesserThan(HoodieTableVersion.NINE) && KeyGenUtils.isComplexKeyGeneratorWithSingleRecordKeyField(tableConfig);
    }
}

