/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataTableFileGroupIndexParser;

public class BucketizedMetadataTableFileGroupIndexParser
implements MetadataTableFileGroupIndexParser {
    private final Map<String, Integer> partitionToBaseIndexOffset;
    private final int numberOfFileGroups;

    public BucketizedMetadataTableFileGroupIndexParser(Map<String, Integer> partitionSizes) {
        this.numberOfFileGroups = BucketizedMetadataTableFileGroupIndexParser.calculateNumberOfFileGroups(partitionSizes);
        this.partitionToBaseIndexOffset = BucketizedMetadataTableFileGroupIndexParser.generatePartitionToBaseIndexOffsets(partitionSizes);
    }

    public static Map<String, Integer> generatePartitionToBaseIndexOffsets(Map<String, Integer> partitionSizes) {
        HashMap<String, Integer> partitionIndexOffsets = new HashMap<String, Integer>(partitionSizes.size());
        int runningSum = 0;
        Object[] sortedPartitionNames = partitionSizes.keySet().toArray(new String[0]);
        Arrays.sort(sortedPartitionNames);
        for (Object partitionName : sortedPartitionNames) {
            partitionIndexOffsets.put((String)partitionName, runningSum);
            runningSum += partitionSizes.get(partitionName).intValue();
        }
        return partitionIndexOffsets;
    }

    public static int calculateNumberOfFileGroups(Map<String, Integer> partitionSizes) {
        return partitionSizes.values().stream().mapToInt(Integer::intValue).sum();
    }

    @Override
    public int getFileGroupIndex(String fileID) {
        String partitionName = HoodieTableMetadataUtil.getDataTablePartitionNameFromFileGroupName((String)fileID);
        return this.partitionToBaseIndexOffset.get(partitionName) + HoodieTableMetadataUtil.getFileGroupIndexFromFileId((String)fileID);
    }

    @Override
    public int getNumberOfFileGroups() {
        return this.numberOfFileGroups;
    }
}

