/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieMetadataColumnStats;
import org.apache.hudi.avro.model.HoodieMetadataRecord;
import org.apache.hudi.client.FailOnFirstErrorWriteStatus;
import org.apache.hudi.client.transaction.lock.InProcessLockProvider;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.config.HoodieStorageConfig;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.data.HoodieListData;
import org.apache.hudi.common.data.HoodiePairData;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.function.SerializableFunctionUnchecked;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.HoodieAvroRecordMerger;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.marker.MarkerType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.SpillableMapBasedFileSystemView;
import org.apache.hudi.common.table.view.SyncableFileSystemView;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodiePayloadConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.config.metrics.HoodieMetricsDatadogConfig;
import org.apache.hudi.config.metrics.HoodieMetricsGraphiteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsJmxConfig;
import org.apache.hudi.config.metrics.HoodieMetricsM3Config;
import org.apache.hudi.config.metrics.HoodieMetricsPrometheusConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.metadata.HoodieIndexVersion;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataKeyGenerator;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.stats.HoodieColumnRangeMetadata;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;
import org.apache.hudi.table.action.compact.strategy.UnBoundedCompactionStrategy;
import org.apache.hudi.util.Lazy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieMetadataWriteUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieMetadataWriteUtils.class);
    public static final String RECORD_KEY_FIELD_NAME = "key";
    private static final int MDT_DEFAULT_PARALLELISM = 512;
    private static final long MDT_MAX_HFILE_SIZE_BYTES = 0x280000000L;

    @VisibleForTesting
    public static HoodieWriteConfig createMetadataWriteConfig(HoodieWriteConfig writeConfig, HoodieFailedWritesCleaningPolicy failedWritesCleaningPolicy, HoodieTableVersion datatableVersion) {
        HoodieWriteConfig metadataWriteConfig;
        HoodieLockConfig lockConfig;
        String tableName = writeConfig.getTableName() + "_metadata";
        boolean isStreamingWritesToMetadataEnabled = writeConfig.isMetadataStreamingWritesEnabled(datatableVersion);
        WriteConcurrencyMode concurrencyMode = isStreamingWritesToMetadataEnabled ? WriteConcurrencyMode.NON_BLOCKING_CONCURRENCY_CONTROL : WriteConcurrencyMode.SINGLE_WRITER;
        HoodieLockConfig hoodieLockConfig = lockConfig = isStreamingWritesToMetadataEnabled ? HoodieLockConfig.newBuilder().withLockProvider(InProcessLockProvider.class).build() : HoodieLockConfig.newBuilder().build();
        if (isStreamingWritesToMetadataEnabled) {
            failedWritesCleaningPolicy = HoodieFailedWritesCleaningPolicy.LAZY;
        }
        long maxLogFileSizeBytes = writeConfig.getMetadataConfig().getMaxLogFileSize();
        HoodieCleaningPolicy dataTableCleaningPolicy = writeConfig.getCleanerPolicy();
        HoodieCleanConfig.Builder cleanConfigBuilder = HoodieCleanConfig.newBuilder().withAsyncClean(false).withAutoClean(false).withCleanerParallelism(512).withFailedWritesCleaningPolicy(failedWritesCleaningPolicy).withCleanerPolicy(dataTableCleaningPolicy);
        if (HoodieCleaningPolicy.KEEP_LATEST_COMMITS.equals((Object)dataTableCleaningPolicy)) {
            int retainCommits = (int)Math.max(20.0, (double)writeConfig.getCleanerCommitsRetained() * 1.2);
            cleanConfigBuilder.retainCommits(retainCommits);
        } else if (HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS.equals((Object)dataTableCleaningPolicy)) {
            int retainFileVersions = (int)Math.ceil((double)writeConfig.getCleanerFileVersionsRetained() * 1.2);
            cleanConfigBuilder.retainFileVersions(retainFileVersions);
        } else if (HoodieCleaningPolicy.KEEP_LATEST_BY_HOURS.equals((Object)dataTableCleaningPolicy)) {
            int numHoursRetained = (int)Math.ceil((double)writeConfig.getCleanerHoursRetained() * 1.2);
            cleanConfigBuilder.cleanerNumHoursRetained(numHoursRetained);
        }
        HoodieWriteConfig.Builder builder = HoodieWriteConfig.newBuilder().withEngineType(writeConfig.getEngineType()).withWriteTableVersion(writeConfig.getWriteVersion().versionCode()).withMergeAllowDuplicateOnInserts(false).withConsistencyGuardConfig(ConsistencyGuardConfig.newBuilder().withConsistencyCheckEnabled(writeConfig.getConsistencyGuardConfig().isConsistencyCheckEnabled()).withInitialConsistencyCheckIntervalMs(writeConfig.getConsistencyGuardConfig().getInitialConsistencyCheckIntervalMs()).withMaxConsistencyCheckIntervalMs(writeConfig.getConsistencyGuardConfig().getMaxConsistencyCheckIntervalMs()).withMaxConsistencyChecks(writeConfig.getConsistencyGuardConfig().getMaxConsistencyChecks()).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(false).withFileListingParallelism(writeConfig.getFileListingParallelism()).build()).withAvroSchemaValidate(false).withEmbeddedTimelineServerEnabled(false).withMarkersType(MarkerType.DIRECT.name()).withRollbackUsingMarkers(false).withPath(HoodieTableMetadata.getMetadataTableBasePath((String)writeConfig.getBasePath())).withSchema(HoodieMetadataRecord.getClassSchema().toString()).forTable(tableName).withCleanConfig(cleanConfigBuilder.build()).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(writeConfig.getMinCommitsToKeep() + 1, writeConfig.getMaxCommitsToKeep() + 1).withAutoArchive(false).build()).withCompactionConfig(HoodieCompactionConfig.newBuilder().withInlineCompaction(false).withMaxNumDeltaCommitsBeforeCompaction(writeConfig.getMetadataCompactDeltaCommitMax()).withEnableOptimizedLogBlocksScan(String.valueOf(writeConfig.enableOptimizedLogBlocksScan())).withCompactionStrategy(new UnBoundedCompactionStrategy()).withLogCompactionEnabled(writeConfig.isLogCompactionEnabledOnMetadata()).withLogCompactionBlocksThreshold(writeConfig.getMetadataLogCompactBlocksThreshold()).build()).withStorageConfig(HoodieStorageConfig.newBuilder().hfileMaxFileSize(0x280000000L).logFileMaxSize(maxLogFileSizeBytes).logFileDataBlockMaxSize(maxLogFileSizeBytes).withBloomFilterType(writeConfig.getMetadataConfig().getBloomFilterType()).withBloomFilterNumEntries(writeConfig.getMetadataConfig().getBloomFilterNumEntries()).withBloomFilterFpp(writeConfig.getMetadataConfig().getBloomFilterFpp()).withBloomFilterDynamicMaxEntries(writeConfig.getMetadataConfig().getDynamicBloomFilterMaxNumEntries()).build()).withRollbackParallelism(512).withFinalizeWriteParallelism(512).withKeyGenerator(HoodieTableMetadataKeyGenerator.class.getCanonicalName()).withPopulateMetaFields(false).withWriteStatusClass(FailOnFirstErrorWriteStatus.class).withReleaseResourceEnabled(writeConfig.areReleaseResourceEnabled()).withRecordMergeMode(RecordMergeMode.CUSTOM).withRecordMergeStrategyId("00000000-0000-0000-0000-000000000000").withPayloadConfig(HoodiePayloadConfig.newBuilder().withPayloadClass(HoodieMetadataPayload.class.getCanonicalName()).build()).withRecordMergeImplClasses(HoodieAvroRecordMerger.class.getCanonicalName()).withWriteRecordPositionsEnabled(false).withWriteConcurrencyMode(concurrencyMode).withLockConfig(lockConfig);
        Properties properties = new Properties();
        properties.put(HoodieTableConfig.TYPE.key(), HoodieTableType.MERGE_ON_READ.name());
        properties.put(HoodieTableConfig.RECORDKEY_FIELDS.key(), RECORD_KEY_FIELD_NAME);
        properties.put("hoodie.datasource.write.recordkey.field", RECORD_KEY_FIELD_NAME);
        if (StringUtils.nonEmpty((String)writeConfig.getMetricReporterMetricsNamePrefix())) {
            properties.put(HoodieMetricsConfig.METRICS_REPORTER_PREFIX.key(), writeConfig.getMetricReporterMetricsNamePrefix() + "_metadata");
        }
        properties.put(HoodieReaderConfig.HFILE_BLOCK_CACHE_ENABLED.key(), (Object)writeConfig.getBooleanOrDefault(HoodieReaderConfig.HFILE_BLOCK_CACHE_ENABLED));
        properties.put(HoodieReaderConfig.HFILE_BLOCK_CACHE_SIZE.key(), writeConfig.getIntOrDefault(HoodieReaderConfig.HFILE_BLOCK_CACHE_SIZE));
        properties.put(HoodieReaderConfig.HFILE_BLOCK_CACHE_TTL_MINUTES.key(), writeConfig.getIntOrDefault(HoodieReaderConfig.HFILE_BLOCK_CACHE_TTL_MINUTES));
        builder.withProperties(properties);
        if (writeConfig.isMetricsOn()) {
            Properties commonProperties = new Properties();
            commonProperties.put(HoodieWriteConfig.TBL_NAME.key(), tableName);
            builder.withMetricsConfig(HoodieMetricsConfig.newBuilder().fromProperties(commonProperties).withReporterType(writeConfig.getMetricsReporterType().toString()).withExecutorMetrics(writeConfig.isExecutorMetricsEnabled()).withMetricsReporterMetricNamePrefix(writeConfig.getMetricReporterMetricsNamePrefix() + "_" + "metadata").on(true).build());
            switch (writeConfig.getMetricsReporterType()) {
                case GRAPHITE: {
                    builder.withMetricsGraphiteConfig(HoodieMetricsGraphiteConfig.newBuilder().onGraphitePort(writeConfig.getGraphiteServerPort()).toGraphiteHost(writeConfig.getGraphiteServerHost()).usePrefix(writeConfig.getGraphiteMetricPrefix()).build());
                    break;
                }
                case JMX: {
                    builder.withMetricsJmxConfig(HoodieMetricsJmxConfig.newBuilder().onJmxPort(writeConfig.getJmxPort()).toJmxHost(writeConfig.getJmxHost()).build());
                    break;
                }
                case PROMETHEUS_PUSHGATEWAY: {
                    HoodieMetricsPrometheusConfig pushGatewayConfig = HoodieMetricsPrometheusConfig.newBuilder().withPushgatewayJobname(writeConfig.getPushGatewayJobName()).withPushgatewayRandomJobnameSuffix(writeConfig.getPushGatewayRandomJobNameSuffix()).withPushgatewayLabels(writeConfig.getPushGatewayLabels()).withPushgatewayReportPeriodInSeconds(String.valueOf(writeConfig.getPushGatewayReportPeriodSeconds())).withPushgatewayHostName(writeConfig.getPushGatewayHost()).withPushgatewayPortNum(Integer.valueOf(writeConfig.getPushGatewayPort())).build();
                    builder.withProperties((Properties)pushGatewayConfig.getProps());
                    break;
                }
                case M3: {
                    HoodieMetricsM3Config m3Config = HoodieMetricsM3Config.newBuilder().onM3Port(writeConfig.getM3ServerPort()).toM3Host(writeConfig.getM3ServerHost()).useM3Tags(writeConfig.getM3Tags()).useM3Service(writeConfig.getM3Service()).useM3Env(writeConfig.getM3Env()).build();
                    builder.withProperties((Properties)m3Config.getProps());
                    break;
                }
                case DATADOG: {
                    HoodieMetricsDatadogConfig.Builder datadogConfig = HoodieMetricsDatadogConfig.newBuilder().withDatadogApiKey(writeConfig.getDatadogApiKey()).withDatadogApiKeySkipValidation(writeConfig.getDatadogApiKeySkipValidation()).withDatadogPrefix(writeConfig.getDatadogMetricPrefix()).withDatadogReportPeriodSeconds(writeConfig.getDatadogReportPeriodSeconds()).withDatadogTags(String.join((CharSequence)",", writeConfig.getDatadogMetricTags())).withDatadogApiTimeoutSeconds(writeConfig.getDatadogApiTimeoutSeconds());
                    if (writeConfig.getDatadogMetricHost() != null) {
                        datadogConfig = datadogConfig.withDatadogHost(writeConfig.getDatadogMetricHost());
                    }
                    if (writeConfig.getDatadogApiSite() != null) {
                        datadogConfig = datadogConfig.withDatadogApiSite(writeConfig.getDatadogApiSite().name());
                    }
                    builder.withProperties((Properties)datadogConfig.build().getProps());
                    break;
                }
                case PROMETHEUS: {
                    HoodieMetricsPrometheusConfig prometheusConfig = HoodieMetricsPrometheusConfig.newBuilder().withPushgatewayLabels(writeConfig.getPushGatewayLabels()).withPrometheusPortNum(writeConfig.getPrometheusPort()).build();
                    builder.withProperties((Properties)prometheusConfig.getProps());
                    break;
                }
                case CONSOLE: 
                case INMEMORY: 
                case CLOUDWATCH: {
                    break;
                }
                default: {
                    throw new HoodieMetadataException("Unsupported Metrics Reporter type " + writeConfig.getMetricsReporterType());
                }
            }
        }
        ValidationUtils.checkArgument((!(metadataWriteConfig = builder.build()).isAutoClean() ? 1 : 0) != 0, (String)"Cleaning is controlled internally for Metadata table.");
        ValidationUtils.checkArgument((!metadataWriteConfig.inlineCompactionEnabled() ? 1 : 0) != 0, (String)"Compaction is controlled internally for metadata table.");
        ValidationUtils.checkArgument((boolean)metadataWriteConfig.getWriteStatusClassName().equals(FailOnFirstErrorWriteStatus.class.getName()), (String)("MDT should use " + FailOnFirstErrorWriteStatus.class.getName()));
        ValidationUtils.checkArgument((!metadataWriteConfig.isMetadataTableEnabled() ? 1 : 0) != 0, (String)"File listing cannot be used for Metadata Table");
        return metadataWriteConfig;
    }

    public static Map<String, HoodieData<HoodieRecord>> convertMetadataToRecords(HoodieEngineContext context, HoodieWriteConfig dataWriteConfig, HoodieCommitMetadata commitMetadata, String instantTime, HoodieTableMetaClient dataMetaClient, HoodieTableMetadata tableMetadata, HoodieMetadataConfig metadataConfig, Set<String> enabledPartitionTypes, String bloomFilterType, int bloomIndexParallelism, int writesFileIdEncoding, EngineType engineType, Option<HoodieRecord.HoodieRecordType> recordTypeOpt, boolean enableOptimizeLogBlocksScan) {
        HashMap<String, HoodieData<HoodieRecord>> partitionToRecordsMap = new HashMap<String, HoodieData<HoodieRecord>>();
        HoodieData filesPartitionRecordsRDD = context.parallelize(HoodieTableMetadataUtil.convertMetadataToFilesPartitionRecords((HoodieCommitMetadata)commitMetadata, (String)instantTime), 1);
        partitionToRecordsMap.put(MetadataPartitionType.FILES.getPartitionPath(), filesPartitionRecordsRDD);
        if (enabledPartitionTypes.contains(MetadataPartitionType.BLOOM_FILTERS.getPartitionPath())) {
            HoodieData metadataBloomFilterRecords = HoodieTableMetadataUtil.convertMetadataToBloomFilterRecords((HoodieEngineContext)context, (HoodieConfig)dataWriteConfig, (HoodieCommitMetadata)commitMetadata, (String)instantTime, (HoodieTableMetaClient)dataMetaClient, (String)bloomFilterType, (int)bloomIndexParallelism);
            partitionToRecordsMap.put(MetadataPartitionType.BLOOM_FILTERS.getPartitionPath(), metadataBloomFilterRecords);
        }
        if (enabledPartitionTypes.contains(MetadataPartitionType.COLUMN_STATS.getPartitionPath())) {
            HoodieData metadataColumnStatsRDD = HoodieTableMetadataUtil.convertMetadataToColumnStatsRecords((HoodieCommitMetadata)commitMetadata, (HoodieEngineContext)context, (HoodieTableMetaClient)dataMetaClient, (HoodieMetadataConfig)metadataConfig, recordTypeOpt);
            partitionToRecordsMap.put(MetadataPartitionType.COLUMN_STATS.getPartitionPath(), metadataColumnStatsRDD);
        }
        if (enabledPartitionTypes.contains(MetadataPartitionType.PARTITION_STATS.getPartitionPath())) {
            ValidationUtils.checkState((boolean)MetadataPartitionType.COLUMN_STATS.isMetadataPartitionAvailable(dataMetaClient), (String)("Column stats partition must be enabled to generate partition stats. Please enable: " + HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()));
            boolean isDeletePartition = commitMetadata.getOperationType().equals((Object)WriteOperationType.DELETE_PARTITION);
            HoodieData<HoodieRecord> partitionStatsRDD = HoodieMetadataWriteUtils.convertMetadataToPartitionStatRecords(commitMetadata, instantTime, context, dataWriteConfig, dataMetaClient, tableMetadata, metadataConfig, recordTypeOpt, isDeletePartition);
            partitionToRecordsMap.put(MetadataPartitionType.PARTITION_STATS.getPartitionPath(), partitionStatsRDD);
        }
        if (enabledPartitionTypes.contains(MetadataPartitionType.RECORD_INDEX.getPartitionPath())) {
            partitionToRecordsMap.put(MetadataPartitionType.RECORD_INDEX.getPartitionPath(), (HoodieData<HoodieRecord>)HoodieTableMetadataUtil.convertMetadataToRecordIndexRecords((HoodieEngineContext)context, (HoodieCommitMetadata)commitMetadata, (HoodieMetadataConfig)metadataConfig, (HoodieTableMetaClient)dataMetaClient, (int)writesFileIdEncoding, (String)instantTime, (EngineType)engineType, (boolean)enableOptimizeLogBlocksScan));
        }
        return partitionToRecordsMap;
    }

    public static HoodieData<HoodieRecord> convertMetadataToPartitionStatRecords(HoodieCommitMetadata commitMetadata, String instantTime, HoodieEngineContext engineContext, HoodieWriteConfig dataWriteConfig, HoodieTableMetaClient dataMetaClient, HoodieTableMetadata tableMetadata, HoodieMetadataConfig metadataConfig, Option<HoodieRecord.HoodieRecordType> recordTypeOpt, boolean isDeletePartition) {
        try {
            Option writerSchema = Option.ofNullable((Object)commitMetadata.getMetadata("schema")).flatMap(writerSchemaStr -> StringUtils.isNullOrEmpty((String)writerSchemaStr) ? Option.empty() : Option.of((Object)new Schema.Parser().parse(writerSchemaStr)));
            HoodieTableConfig tableConfig = dataMetaClient.getTableConfig();
            Option tableSchema = writerSchema.map(schema -> tableConfig.populateMetaFields() ? HoodieAvroUtils.addMetadataFields((Schema)schema) : schema);
            if (tableSchema.isEmpty()) {
                return engineContext.emptyHoodieData();
            }
            HoodieIndexVersion partitionStatsIndexVersion = HoodieTableMetadataUtil.existingIndexVersionOrDefault((String)"partition_stats", (HoodieTableMetaClient)dataMetaClient);
            Lazy writerSchemaOpt = Lazy.eagerly((Object)tableSchema);
            Map columnsToIndexSchemaMap = HoodieTableMetadataUtil.getColumnsToIndex((HoodieTableConfig)dataMetaClient.getTableConfig(), (HoodieMetadataConfig)metadataConfig, (Lazy)writerSchemaOpt, (boolean)false, recordTypeOpt, (HoodieIndexVersion)partitionStatsIndexVersion);
            if (columnsToIndexSchemaMap.isEmpty()) {
                return engineContext.emptyHoodieData();
            }
            if (isDeletePartition) {
                HoodieReplaceCommitMetadata replaceCommitMetadata = (HoodieReplaceCommitMetadata)commitMetadata;
                Map partitionToReplaceFileIds = replaceCommitMetadata.getPartitionToReplaceFileIds();
                ArrayList partitionsToDelete = new ArrayList(partitionToReplaceFileIds.keySet());
                if (partitionToReplaceFileIds.isEmpty()) {
                    return engineContext.emptyHoodieData();
                }
                return engineContext.parallelize(partitionsToDelete, partitionsToDelete.size()).flatMap((SerializableFunction & Serializable)partition -> {
                    Stream columnRangeMetadata = columnsToIndexSchemaMap.keySet().stream().flatMap(column -> HoodieMetadataPayload.createPartitionStatsRecords((String)partition, Collections.singletonList(HoodieColumnRangeMetadata.stub((String)"", (String)column, (HoodieIndexVersion)partitionStatsIndexVersion)), (boolean)true, (boolean)true, (Option)Option.empty()));
                    return columnRangeMetadata.iterator();
                });
            }
            List allWriteStats = commitMetadata.getPartitionToWriteStats().values().stream().flatMap(Collection::stream).collect(Collectors.toList());
            if (allWriteStats.isEmpty()) {
                return engineContext.emptyHoodieData();
            }
            ArrayList colsToIndex = new ArrayList(columnsToIndexSchemaMap.keySet());
            LOG.debug("Indexing following columns for partition stats index: {}", columnsToIndexSchemaMap.keySet());
            ArrayList<List<HoodieWriteStat>> partitionedWriteStats = new ArrayList<List<HoodieWriteStat>>(allWriteStats.stream().collect(Collectors.groupingBy(HoodieWriteStat::getPartitionPath)).values());
            Map fileGroupIdsToReplaceMap = commitMetadata instanceof HoodieReplaceCommitMetadata ? ((HoodieReplaceCommitMetadata)commitMetadata).getPartitionToReplaceFileIds().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new HashSet((Collection)e.getValue()))) : Collections.emptyMap();
            int parallelism = Math.max(Math.min(partitionedWriteStats.size(), metadataConfig.getPartitionStatsIndexParallelism()), 1);
            String maxInstantTime = HoodieMetadataWriteUtils.getMaxInstantTime(dataMetaClient, instantTime);
            HoodiePairData columnRangeMetadata = engineContext.parallelize(partitionedWriteStats, parallelism).mapToPair((SerializablePairFunction & Serializable)partitionedWriteStat -> {
                String partitionName = ((HoodieWriteStat)partitionedWriteStat.get(0)).getPartitionPath();
                ValidationUtils.checkState((tableMetadata != null ? 1 : 0) != 0, (String)"tableMetadata should not be null when scanning metadata table");
                List fileColumnMetadata = partitionedWriteStat.stream().flatMap(writeStat -> HoodieTableMetadataUtil.translateWriteStatToFileStats((HoodieWriteStat)writeStat, (HoodieTableMetaClient)dataMetaClient, (List)colsToIndex, (HoodieIndexVersion)partitionStatsIndexVersion).stream()).collect(Collectors.toList());
                Set<String> filesToFetchColumnStats = HoodieMetadataWriteUtils.getFilesToFetchColumnStats(partitionedWriteStat, dataMetaClient, tableMetadata, dataWriteConfig, partitionName, maxInstantTime, instantTime, fileGroupIdsToReplaceMap, colsToIndex, partitionStatsIndexVersion);
                List partitionColumnMetadata = tableMetadata.getRecordsByKeyPrefixes((HoodieData)HoodieListData.lazy((List)HoodieTableMetadataUtil.generateColumnStatsKeys((List)colsToIndex, (String)partitionName)), MetadataPartitionType.COLUMN_STATS.getPartitionPath(), false).map((SerializableFunction & Serializable)record -> ((HoodieMetadataPayload)record.getData()).getColumnStatMetadata()).filter(Option::isPresent).map((SerializableFunction & Serializable)colStatsOpt -> (HoodieMetadataColumnStats)colStatsOpt.get()).filter((SerializableFunction & Serializable)stats -> filesToFetchColumnStats.contains(stats.getFileName())).map(HoodieColumnRangeMetadata::fromColumnStats).collectAsList();
                fileColumnMetadata.addAll(partitionColumnMetadata);
                return Pair.of((Object)partitionName, fileColumnMetadata);
            });
            return HoodieTableMetadataUtil.convertMetadataToPartitionStatsRecords((HoodiePairData)columnRangeMetadata, (HoodieTableMetaClient)dataMetaClient, (Map)columnsToIndexSchemaMap, (HoodieIndexVersion)partitionStatsIndexVersion);
        }
        catch (Exception e2) {
            throw new HoodieException("Failed to generate column stats records for metadata table", (Throwable)e2);
        }
    }

    private static StoragePathInfo getBaseFileStoragePathInfo(HoodieBaseFile baseFile) {
        StoragePathInfo pathInfo = baseFile.getPathInfo();
        if (pathInfo != null) {
            return pathInfo;
        }
        return new StoragePathInfo(baseFile.getStoragePath(), baseFile.getFileLen(), false, 0, 0L, 0L);
    }

    private static StoragePathInfo getLogFileStoragePathInfo(HoodieLogFile logFile) {
        StoragePathInfo pathInfo = logFile.getPathInfo();
        if (pathInfo != null) {
            return pathInfo;
        }
        return new StoragePathInfo(logFile.getPath(), logFile.getFileSize(), false, 0, 0L, 0L);
    }

    public static String getMaxInstantTime(HoodieTableMetaClient dataMetaClient, String instantTime) {
        Option lastCompletedInstant = dataMetaClient.getActiveTimeline().filterCompletedInstants().lastInstant().map(HoodieInstant::requestedTime);
        return (String)lastCompletedInstant.map(lastCompletedInstantTime -> lastCompletedInstantTime.compareTo(instantTime) > 0 ? lastCompletedInstantTime : instantTime).orElse((Object)instantTime);
    }

    public static Set<String> getFilesToFetchColumnStats(List<HoodieWriteStat> partitionedWriteStat, HoodieTableMetaClient dataMetaClient, HoodieTableMetadata tableMetadata, HoodieWriteConfig dataWriteConfig, String partitionName, String maxInstantTime, String instantTime, Map<String, Set<String>> fileGroupIdsToReplaceMap, List<String> colsToIndex, HoodieIndexVersion partitionStatsIndexVersion) {
        ArrayList consolidatedPathInfos = new ArrayList();
        partitionedWriteStat.forEach(stat -> consolidatedPathInfos.add(new StoragePathInfo(new StoragePath(dataMetaClient.getBasePath(), stat.getPath()), stat.getFileSizeInBytes(), false, 0, 0L, 0L)));
        SyncableFileSystemView fileSystemViewForCommitedFiles = FileSystemViewManager.createViewManager((HoodieEngineContext)new HoodieLocalEngineContext(dataMetaClient.getStorageConf()), (HoodieMetadataConfig)dataWriteConfig.getMetadataConfig(), (FileSystemViewStorageConfig)dataWriteConfig.getViewStorageConfig(), (HoodieCommonConfig)dataWriteConfig.getCommonConfig(), (SerializableFunctionUnchecked & Serializable)unused -> tableMetadata).getFileSystemView(dataMetaClient);
        fileSystemViewForCommitedFiles.getLatestMergedFileSlicesBeforeOrOn(partitionName, maxInstantTime).forEach(fileSlice -> {
            if (fileSlice.getBaseFile().isPresent()) {
                consolidatedPathInfos.add(HoodieMetadataWriteUtils.getBaseFileStoragePathInfo((HoodieBaseFile)fileSlice.getBaseFile().get()));
            }
            fileSlice.getLogFiles().forEach(logFile -> consolidatedPathInfos.add(HoodieMetadataWriteUtils.getLogFileStoragePathInfo(logFile)));
        });
        SpillableMapBasedFileSystemView consolidatedFileSystemView = new SpillableMapBasedFileSystemView(tableMetadata, dataMetaClient, (HoodieTimeline)dataMetaClient.getActiveTimeline(), consolidatedPathInfos, dataWriteConfig.getViewStorageConfig(), dataWriteConfig.getCommonConfig());
        List fileColumnMetadata = partitionedWriteStat.stream().flatMap(writeStat -> HoodieTableMetadataUtil.translateWriteStatToFileStats((HoodieWriteStat)writeStat, (HoodieTableMetaClient)dataMetaClient, (List)colsToIndex, (HoodieIndexVersion)partitionStatsIndexVersion).stream()).collect(Collectors.toList());
        Set fileGroupIdsToReplace = fileGroupIdsToReplaceMap.getOrDefault(partitionName, Collections.emptySet());
        Set filesWithColumnStats = partitionedWriteStat.stream().map(stat -> new StoragePath(stat.getPath()).getName()).collect(Collectors.toSet());
        return consolidatedFileSystemView.getLatestMergedFileSlicesBeforeOrOnIncludingInflight(partitionName, maxInstantTime, instantTime).flatMap(fileSlice -> Stream.concat(Stream.of(fileSlice.getBaseFile().map(BaseFile::getFileName).orElse(null)), fileSlice.getLogFiles().map(HoodieLogFile::getFileName))).filter(e -> Objects.nonNull(e) && !filesWithColumnStats.contains(e) && !fileGroupIdsToReplace.contains(e)).collect(Collectors.toSet());
    }
}

