/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordDelegate;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieMetadataException;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.MetadataIndexMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordIndexMapper
extends MetadataIndexMapper {
    private static final Logger LOG = LoggerFactory.getLogger(RecordIndexMapper.class);

    public RecordIndexMapper(HoodieWriteConfig dataWriteConfig) {
        super(dataWriteConfig);
    }

    @Override
    protected List<HoodieRecord> generateRecords(WriteStatus writeStatus) {
        ArrayList<HoodieRecord> allRecords = new ArrayList<HoodieRecord>();
        for (HoodieRecordDelegate recordDelegate : writeStatus.getIndexStats().getWrittenRecordDelegates()) {
            HoodieRecord hoodieRecord;
            if (writeStatus.isErrored(recordDelegate.getHoodieKey()) || recordDelegate.getIgnoreIndexUpdate()) continue;
            Option newLocation = recordDelegate.getNewLocation();
            if (newLocation.isPresent()) {
                if (recordDelegate.getCurrentLocation().isPresent()) {
                    if (((HoodieRecordLocation)recordDelegate.getCurrentLocation().get()).getFileId().equals(((HoodieRecordLocation)newLocation.get()).getFileId())) continue;
                    String msg = String.format("Detected update in location of record with key %s from %s to %s. The fileID should not change.", recordDelegate, recordDelegate.getCurrentLocation().get(), newLocation.get());
                    LOG.error(msg);
                    throw new HoodieMetadataException(msg);
                }
                hoodieRecord = HoodieMetadataPayload.createRecordIndexUpdate((String)recordDelegate.getRecordKey(), (String)recordDelegate.getPartitionPath(), (String)((HoodieRecordLocation)newLocation.get()).getFileId(), (String)((HoodieRecordLocation)newLocation.get()).getInstantTime(), (int)this.dataWriteConfig.getWritesFileIdEncoding());
                allRecords.add(hoodieRecord);
                continue;
            }
            hoodieRecord = HoodieMetadataPayload.createRecordIndexDelete((String)recordDelegate.getRecordKey(), (String)recordDelegate.getPartitionPath(), (boolean)this.dataWriteConfig.isRecordLevelIndexEnabled());
            allRecords.add(hoodieRecord);
        }
        return allRecords;
    }
}

