/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hudi.client.SecondaryIndexStats;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.MetadataIndexMapper;

public class SecondaryIndexMapper
extends MetadataIndexMapper {
    public SecondaryIndexMapper(HoodieWriteConfig dataWriteConfig) {
        super(dataWriteConfig);
    }

    @Override
    protected List<HoodieRecord> generateRecords(WriteStatus writeStatus) {
        ArrayList<HoodieRecord> secondaryIndexRecords = new ArrayList<HoodieRecord>(writeStatus.getIndexStats().getSecondaryIndexStats().size());
        for (Map.Entry<String, List<SecondaryIndexStats>> entry : writeStatus.getIndexStats().getSecondaryIndexStats().entrySet()) {
            String indexPartitionName = entry.getKey();
            List<SecondaryIndexStats> secondaryIndexStats = entry.getValue();
            for (SecondaryIndexStats stat : secondaryIndexStats) {
                secondaryIndexRecords.add(HoodieMetadataPayload.createSecondaryIndexRecord((String)stat.getRecordKey(), (String)stat.getSecondaryKeyValue(), (String)indexPartitionName, (Boolean)stat.isDeleted()));
            }
        }
        return secondaryIndexRecords;
    }

    @Override
    public HoodieData<HoodieRecord> postProcess(HoodieData<HoodieRecord> records) {
        int parallelism = Math.max(records.getNumPartitions(), this.dataWriteConfig.getMetadataConfig().getSecondaryIndexParallelism());
        return HoodieTableMetadataUtil.reduceByKeys(records, (int)parallelism, (boolean)false);
    }
}

