/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.engine.ReaderContextFactory;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.read.HoodieFileGroupReader;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.view.FileSystemViewManager;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.TableFileSystemView;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.collection.CloseableMappingIterator;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;

public class SecondaryIndexRecordGenerationUtils {
    @VisibleForTesting
    public static <T> HoodieData<HoodieRecord> convertWriteStatsToSecondaryIndexRecords(List<HoodieWriteStat> allWriteStats, String instantTime, HoodieIndexDefinition indexDefinition, HoodieMetadataConfig metadataConfig, HoodieTableMetaClient dataMetaClient, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        Schema tableSchema;
        TypedProperties props = writeConfig.getProps();
        if (allWriteStats.stream().anyMatch(writeStat -> {
            String fileName = FSUtils.getFileName((String)writeStat.getPath(), (String)writeStat.getPartitionPath());
            return FSUtils.isLogFile((String)fileName) && writeStat.getNumInserts() > 0L;
        })) {
            throw new HoodieIOException("Secondary index cannot support logs having inserts with current offering. Please disable secondary index.");
        }
        try {
            tableSchema = (Schema)HoodieTableMetadataUtil.tryResolveSchemaForTable((HoodieTableMetaClient)dataMetaClient).get();
        }
        catch (Exception e) {
            throw new HoodieException("Failed to get latest schema for " + dataMetaClient.getBasePath(), (Throwable)e);
        }
        Map<String, List<HoodieWriteStat>> writeStatsByFileId = allWriteStats.stream().collect(Collectors.groupingBy(HoodieWriteStat::getFileId));
        int parallelism = Math.max(Math.min(writeStatsByFileId.size(), metadataConfig.getSecondaryIndexParallelism()), 1);
        ReaderContextFactory readerContextFactory = engineContext.getReaderContextFactory(dataMetaClient);
        HoodieData secondaryIndexRecords = engineContext.parallelize(new ArrayList<Map.Entry<String, List<HoodieWriteStat>>>(writeStatsByFileId.entrySet()), parallelism).flatMap((SerializableFunction & Serializable)writeStatsByFileIdEntry -> {
            Map<String, String> recordKeyToSecondaryKeyForCurrentFileSlice;
            FileSlice currentFileSliceForFileId;
            Map<Object, Object> recordKeyToSecondaryKeyForPreviousFileSlice;
            TableFileSystemView.SliceView sliceView;
            Option fileSliceOption;
            String fileId = (String)writeStatsByFileIdEntry.getKey();
            List writeStats = (List)writeStatsByFileIdEntry.getValue();
            String partition = ((HoodieWriteStat)writeStats.get(0)).getPartitionPath();
            StoragePath basePath = dataMetaClient.getBasePath();
            AtomicInteger totalParquetFiles = new AtomicInteger();
            AtomicInteger totalLogFiles = new AtomicInteger();
            writeStats.stream().forEach(writeStat -> {
                if (FSUtils.isLogFile((StoragePath)new StoragePath(basePath, writeStat.getPath()))) {
                    totalLogFiles.getAndIncrement();
                } else {
                    totalParquetFiles.getAndIncrement();
                }
            });
            ValidationUtils.checkArgument((totalParquetFiles.get() <= 0 || totalLogFiles.get() <= 0 ? 1 : 0) != 0, (String)("Only either of base file or log files are expected for a given file group. Partition " + partition + ", fileId " + fileId));
            if (totalParquetFiles.get() > 0) {
                ValidationUtils.checkArgument((writeStats.size() == 1 ? 1 : 0) != 0, (String)"Only one new parquet file expected per file group per commit");
            }
            if ((fileSliceOption = (sliceView = SecondaryIndexRecordGenerationUtils.getSliceView(writeConfig, dataMetaClient)).getLatestMergedFileSliceBeforeOrOn(partition, instantTime, fileId)).isPresent()) {
                recordKeyToSecondaryKeyForPreviousFileSlice = SecondaryIndexRecordGenerationUtils.getRecordKeyToSecondaryKey(dataMetaClient, readerContextFactory.getContext(), (FileSlice)fileSliceOption.get(), tableSchema, indexDefinition, instantTime, props, false);
                if (totalParquetFiles.get() > 0) {
                    currentFileSliceForFileId = new FileSlice(partition, instantTime, fileId);
                    HoodieWriteStat stat = (HoodieWriteStat)writeStats.get(0);
                    StoragePathInfo baseFilePathInfo = new StoragePathInfo(new StoragePath(basePath, stat.getPath()), stat.getFileSizeInBytes(), false, 0, 0L, 0L);
                    currentFileSliceForFileId.setBaseFile(new HoodieBaseFile(baseFilePathInfo));
                    recordKeyToSecondaryKeyForCurrentFileSlice = SecondaryIndexRecordGenerationUtils.getRecordKeyToSecondaryKey(dataMetaClient, readerContextFactory.getContext(), currentFileSliceForFileId, tableSchema, indexDefinition, instantTime, props, true);
                } else {
                    FileSlice latestFileSlice = (FileSlice)fileSliceOption.get();
                    writeStats.stream().forEach(writeStat -> {
                        StoragePathInfo logFile = new StoragePathInfo(new StoragePath(basePath, writeStat.getPath()), writeStat.getFileSizeInBytes(), false, 0, 0L, 0L);
                        latestFileSlice.addLogFile(new HoodieLogFile(logFile));
                    });
                    recordKeyToSecondaryKeyForCurrentFileSlice = SecondaryIndexRecordGenerationUtils.getRecordKeyToSecondaryKey(dataMetaClient, readerContextFactory.getContext(), latestFileSlice, tableSchema, indexDefinition, instantTime, props, true);
                }
            } else {
                recordKeyToSecondaryKeyForPreviousFileSlice = Collections.emptyMap();
                currentFileSliceForFileId = new FileSlice(partition, instantTime, fileId);
                HoodieWriteStat stat = (HoodieWriteStat)writeStats.get(0);
                StoragePathInfo baseFilePathInfo = new StoragePathInfo(new StoragePath(basePath, stat.getPath()), stat.getFileSizeInBytes(), false, 0, 0L, 0L);
                currentFileSliceForFileId.setBaseFile(new HoodieBaseFile(baseFilePathInfo));
                recordKeyToSecondaryKeyForCurrentFileSlice = SecondaryIndexRecordGenerationUtils.getRecordKeyToSecondaryKey(dataMetaClient, readerContextFactory.getContext(), currentFileSliceForFileId, tableSchema, indexDefinition, instantTime, props, true);
            }
            ArrayList records = new ArrayList();
            recordKeyToSecondaryKeyForCurrentFileSlice.forEach((recordKey, secondaryKey) -> {
                if (!recordKeyToSecondaryKeyForPreviousFileSlice.containsKey(recordKey)) {
                    records.add(HoodieMetadataPayload.createSecondaryIndexRecord((String)recordKey, (String)secondaryKey, (String)indexDefinition.getIndexName(), (Boolean)false));
                } else {
                    String previousSecondaryKey = (String)recordKeyToSecondaryKeyForPreviousFileSlice.get(recordKey);
                    if (!Objects.equals(previousSecondaryKey, secondaryKey)) {
                        records.add(HoodieMetadataPayload.createSecondaryIndexRecord((String)recordKey, (String)previousSecondaryKey, (String)indexDefinition.getIndexName(), (Boolean)true));
                        records.add(HoodieMetadataPayload.createSecondaryIndexRecord((String)recordKey, (String)secondaryKey, (String)indexDefinition.getIndexName(), (Boolean)false));
                    }
                }
            });
            recordKeyToSecondaryKeyForPreviousFileSlice.forEach((recordKey, secondaryKey) -> {
                if (!recordKeyToSecondaryKeyForCurrentFileSlice.containsKey(recordKey)) {
                    records.add(HoodieMetadataPayload.createSecondaryIndexRecord((String)recordKey, (String)secondaryKey, (String)indexDefinition.getIndexName(), (Boolean)true));
                }
            });
            return records.iterator();
        });
        return HoodieTableMetadataUtil.reduceByKeys((HoodieData)secondaryIndexRecords, (int)parallelism, (boolean)false);
    }

    private static TableFileSystemView.SliceView getSliceView(HoodieWriteConfig config, HoodieTableMetaClient dataMetaClient) {
        HoodieLocalEngineContext context = new HoodieLocalEngineContext(dataMetaClient.getStorageConf());
        FileSystemViewManager viewManager = FileSystemViewManager.createViewManager((HoodieEngineContext)context, (HoodieMetadataConfig)config.getMetadataConfig(), (FileSystemViewStorageConfig)config.getViewStorageConfig(), (HoodieCommonConfig)config.getCommonConfig(), arg_0 -> SecondaryIndexRecordGenerationUtils.lambda$getSliceView$52f53987$1(config, dataMetaClient, (HoodieEngineContext)context, arg_0));
        return viewManager.getFileSystemView(dataMetaClient);
    }

    private static HoodieTableMetadata getMetadataTable(HoodieWriteConfig config, HoodieTableMetaClient metaClient, HoodieEngineContext context) {
        return metaClient.getTableFormat().getMetadataFactory().create(context, metaClient.getStorage(), config.getMetadataConfig(), config.getBasePath());
    }

    public static <T> Map<String, String> getRecordKeyToSecondaryKey(HoodieTableMetaClient metaClient, HoodieReaderContext<T> readerContext, FileSlice fileSlice, Schema tableSchema, HoodieIndexDefinition indexDefinition, String instantTime, TypedProperties props, boolean allowInflightInstants) throws IOException {
        HashMap<String, String> recordKeyToSecondaryKey = new HashMap<String, String>();
        try (ClosableIterator<Pair<String, String>> recordKeyAndSecondaryIndexValueIter = SecondaryIndexRecordGenerationUtils.createSecondaryIndexRecordGenerator(readerContext, metaClient, fileSlice, tableSchema, indexDefinition, instantTime, props, allowInflightInstants);){
            while (recordKeyAndSecondaryIndexValueIter.hasNext()) {
                Pair recordKeyAndSecondaryIndexValue = (Pair)recordKeyAndSecondaryIndexValueIter.next();
                recordKeyToSecondaryKey.put((String)recordKeyAndSecondaryIndexValue.getKey(), (String)recordKeyAndSecondaryIndexValue.getValue());
            }
        }
        return recordKeyToSecondaryKey;
    }

    public static <T> HoodieData<HoodieRecord> readSecondaryKeysFromFileSlices(HoodieEngineContext engineContext, List<Pair<String, FileSlice>> partitionFileSlicePairs, int secondaryIndexMaxParallelism, String activeModule, HoodieTableMetaClient metaClient, HoodieIndexDefinition indexDefinition, TypedProperties props) {
        Schema tableSchema;
        if (partitionFileSlicePairs.isEmpty()) {
            return engineContext.emptyHoodieData();
        }
        int parallelism = Math.min(partitionFileSlicePairs.size(), secondaryIndexMaxParallelism);
        StoragePath basePath = metaClient.getBasePath();
        try {
            tableSchema = new TableSchemaResolver(metaClient).getTableAvroSchema();
        }
        catch (Exception e) {
            throw new HoodieException("Failed to get latest schema for " + metaClient.getBasePath(), (Throwable)e);
        }
        ReaderContextFactory readerContextFactory = engineContext.getReaderContextFactory(metaClient);
        engineContext.setJobStatus(activeModule, "Secondary Index: reading secondary keys from " + partitionFileSlicePairs.size() + " file slices");
        HoodieFileFormat baseFileFormat = metaClient.getTableConfig().getBaseFileFormat();
        return engineContext.parallelize(partitionFileSlicePairs, parallelism).flatMap((SerializableFunction & Serializable)partitionAndBaseFile -> {
            String partition = (String)partitionAndBaseFile.getKey();
            FileSlice fileSlice = (FileSlice)partitionAndBaseFile.getValue();
            Option dataFilePath = Option.ofNullable((Object)fileSlice.getBaseFile().map(baseFile -> HoodieTableMetadataUtil.filePath((StoragePath)basePath, (String)partition, (String)baseFile.getFileName())).orElseGet(null));
            Schema readerSchema = dataFilePath.isPresent() ? HoodieIOFactory.getIOFactory((HoodieStorage)metaClient.getStorage()).getFileFormatUtils(baseFileFormat).readAvroSchema(metaClient.getStorage(), (StoragePath)dataFilePath.get()) : tableSchema;
            ClosableIterator<Pair<String, String>> secondaryIndexGenerator = SecondaryIndexRecordGenerationUtils.createSecondaryIndexRecordGenerator(readerContextFactory.getContext(), metaClient, fileSlice, readerSchema, indexDefinition, (String)metaClient.getActiveTimeline().filterCompletedInstants().lastInstant().map(HoodieInstant::requestedTime).orElse((Object)""), props, false);
            return new CloseableMappingIterator(secondaryIndexGenerator, pair -> HoodieMetadataPayload.createSecondaryIndexRecord((String)((String)pair.getKey()), (String)((String)pair.getValue()), (String)indexDefinition.getIndexName(), (Boolean)false));
        });
    }

    private static <T> ClosableIterator<Pair<String, String>> createSecondaryIndexRecordGenerator(final HoodieReaderContext<T> readerContext, HoodieTableMetaClient metaClient, FileSlice fileSlice, Schema tableSchema, HoodieIndexDefinition indexDefinition, String instantTime, TypedProperties props, boolean allowInflightInstants) throws IOException {
        final String secondaryKeyField = indexDefinition.getSourceFieldsKey();
        final Schema requestedSchema = SecondaryIndexRecordGenerationUtils.getRequestedSchemaForSecondaryIndex(metaClient, tableSchema, secondaryKeyField);
        final HoodieFileGroupReader fileGroupReader = HoodieFileGroupReader.newBuilder().withReaderContext(readerContext).withFileSlice(fileSlice).withHoodieTableMetaClient(metaClient).withProps(props).withLatestCommitTime(instantTime).withDataSchema(tableSchema).withRequestedSchema(requestedSchema).withAllowInflightInstants(allowInflightInstants).build();
        return new ClosableIterator<Pair<String, String>>(){
            private final ClosableIterator<T> recordIterator;
            private Pair<String, String> nextValidRecord;
            {
                this.recordIterator = fileGroupReader.getClosableIterator();
            }

            public void close() {
                this.recordIterator.close();
            }

            public boolean hasNext() {
                if (this.nextValidRecord != null) {
                    return true;
                }
                if (this.recordIterator.hasNext()) {
                    Object record = this.recordIterator.next();
                    Object secondaryKey = readerContext.getRecordContext().getValue(record, requestedSchema, secondaryKeyField);
                    this.nextValidRecord = Pair.of((Object)readerContext.getRecordContext().getRecordKey(record, requestedSchema), (Object)(secondaryKey == null ? null : secondaryKey.toString()));
                    return true;
                }
                return false;
            }

            public Pair<String, String> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("No more valid records available.");
                }
                Pair<String, String> result = this.nextValidRecord;
                this.nextValidRecord = null;
                return result;
            }
        };
    }

    private static Schema getRequestedSchemaForSecondaryIndex(HoodieTableMetaClient metaClient, Schema tableSchema, String secondaryKeyField) {
        String[] recordKeyFields = tableSchema.getField(HoodieRecord.RECORD_KEY_METADATA_FIELD) != null ? new String[]{HoodieRecord.RECORD_KEY_METADATA_FIELD} : (String[])metaClient.getTableConfig().getRecordKeyFields().orElse((Object)new String[0]);
        String[] projectionFields = Arrays.copyOf(recordKeyFields, recordKeyFields.length + 1);
        projectionFields[recordKeyFields.length] = secondaryKeyField;
        return HoodieAvroUtils.projectSchema((Schema)tableSchema, Arrays.asList(projectionFields));
    }

    private static /* synthetic */ HoodieTableMetadata lambda$getSliceView$52f53987$1(HoodieWriteConfig config, HoodieTableMetaClient dataMetaClient, HoodieEngineContext context, HoodieTableMetaClient unused) {
        return SecondaryIndexRecordGenerationUtils.getMetadataTable(config, dataMetaClient, context);
    }
}

