/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action;

import java.io.Serializable;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieRestoreMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.InstantFileNameGenerator;
import org.apache.hudi.common.table.timeline.InstantFileNameParser;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.table.HoodieTable;

public abstract class BaseActionExecutor<T, I, K, O, R>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final transient HoodieEngineContext context;
    protected final transient StorageConfiguration<?> storageConf;
    protected final HoodieWriteConfig config;
    protected final HoodieTable<T, I, K, O> table;
    protected final InstantGenerator instantGenerator;
    protected final InstantFileNameParser instantFileNameParser;
    protected final InstantFileNameGenerator instantFileNameGenerator;
    protected final String instantTime;

    public BaseActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime) {
        this.context = context;
        this.storageConf = context.getStorageConf();
        this.config = config;
        this.table = table;
        this.instantGenerator = table.getInstantGenerator();
        this.instantFileNameGenerator = table.getInstantFileNameGenerator();
        this.instantFileNameParser = table.getInstantFileNameParser();
        this.instantTime = instantTime;
    }

    public abstract R execute();

    protected final void writeTableMetadata(HoodieCommitMetadata metadata, String actionType) {
        Option<HoodieTableMetadataWriter> metadataWriterOpt;
        if (this.table.getConfig().isMetadataTableEnabled() && WriteOperationType.INSERT_OVERWRITE_TABLE == metadata.getOperationType()) {
            HoodieTableMetadataUtil.deleteMetadataTable((HoodieTableMetaClient)this.table.getMetaClient(), (HoodieEngineContext)this.table.getContext(), (boolean)false);
        }
        if ((metadataWriterOpt = this.table.getMetadataWriter(this.instantTime)).isPresent()) {
            try (HoodieTableMetadataWriter metadataWriter = (HoodieTableMetadataWriter)metadataWriterOpt.get();){
                metadataWriter.update(metadata, this.instantTime);
            }
            catch (Exception e) {
                this.handleMetadataException(e, "Failed to apply " + actionType + " in metadata");
            }
        }
    }

    protected final void writeTableMetadata(HoodieCleanMetadata metadata, String instantTime) {
        Option<HoodieTableMetadataWriter> metadataWriterOpt = this.table.getMetadataWriter(instantTime);
        if (metadataWriterOpt.isPresent()) {
            try (HoodieTableMetadataWriter metadataWriter = (HoodieTableMetadataWriter)metadataWriterOpt.get();){
                metadataWriter.update(metadata, instantTime);
            }
            catch (Exception e) {
                this.handleMetadataException(e, "Failed to apply clean commit to metadata");
            }
        }
    }

    protected final void writeTableMetadata(HoodieRollbackMetadata metadata) {
        Option<HoodieTableMetadataWriter> metadataWriterOpt = this.table.getMetadataWriter(this.instantTime);
        if (metadataWriterOpt.isPresent()) {
            try (HoodieTableMetadataWriter metadataWriter = (HoodieTableMetadataWriter)metadataWriterOpt.get();){
                metadataWriter.update(metadata, this.instantTime);
            }
            catch (Exception e) {
                this.handleMetadataException(e, "Failed to apply rollbacks in metadata");
            }
        }
    }

    protected final void writeTableMetadata(HoodieRestoreMetadata metadata) {
        Option<HoodieTableMetadataWriter> metadataWriterOpt = this.table.getMetadataWriter(this.instantTime);
        if (metadataWriterOpt.isPresent()) {
            try (HoodieTableMetadataWriter metadataWriter = (HoodieTableMetadataWriter)metadataWriterOpt.get();){
                this.dropIndexOnRestore();
                metadataWriter.update(metadata, this.instantTime);
            }
            catch (Exception e) {
                this.handleMetadataException(e, "Failed to apply restore to metadata");
            }
        }
    }

    private void handleMetadataException(Exception e, String errorMessage) {
        if (e instanceof HoodieException) {
            throw (HoodieException)((Object)e);
        }
        throw new HoodieException(errorMessage, (Throwable)e);
    }

    protected final void dropIndexOnRestore() {
        for (String partitionPath : this.table.getMetaClient().getTableConfig().getMetadataPartitions()) {
            if (!MetadataPartitionType.shouldDeletePartitionOnRestore((String)partitionPath)) continue;
            HoodieTableMetadataUtil.deleteMetadataTablePartition((HoodieTableMetaClient)this.table.getMetaClient(), (HoodieEngineContext)this.context, (String)partitionPath, (boolean)true);
        }
    }
}

