/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.cluster;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.TableServiceType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseTableServicePlanActionExecutor;
import org.apache.hudi.table.action.cluster.strategy.ClusteringPlanStrategy;
import org.apache.hudi.util.Lazy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusteringPlanActionExecutor<T, I, K, O>
extends BaseTableServicePlanActionExecutor<T, I, K, O, Option<HoodieClusteringPlan>> {
    private static final Logger LOG = LoggerFactory.getLogger(ClusteringPlanActionExecutor.class);
    private final Option<Map<String, String>> extraMetadata;

    public ClusteringPlanActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, Option<Map<String, String>> extraMetadata) {
        super(context, config, table, instantTime);
        this.extraMetadata = extraMetadata;
    }

    protected Option<HoodieClusteringPlan> createClusteringPlan() {
        LOG.info("Checking if clustering needs to be run on {}", (Object)this.config.getBasePath());
        Option lastClusteringInstant = this.table.getActiveTimeline().getLastClusteringInstant();
        int commitsSinceLastClustering = this.table.getActiveTimeline().getCommitsTimeline().filterCompletedInstants().findInstantsAfter((String)lastClusteringInstant.map(HoodieInstant::requestedTime).orElse((Object)"0"), Integer.MAX_VALUE).countInstants();
        if (this.config.inlineClusteringEnabled() && this.config.getInlineClusterMaxCommits() > commitsSinceLastClustering) {
            LOG.info("Not scheduling inline clustering as only {} commits was found since last clustering {}. Waiting for {}", new Object[]{commitsSinceLastClustering, lastClusteringInstant, this.config.getInlineClusterMaxCommits()});
            return Option.empty();
        }
        if ((this.config.isAsyncClusteringEnabled() || this.config.scheduleInlineClustering()) && this.config.getAsyncClusterMaxCommits() > commitsSinceLastClustering) {
            LOG.info("Not scheduling async clustering as only {} commits was found since last clustering {}. Waiting for {}", new Object[]{commitsSinceLastClustering, lastClusteringInstant, this.config.getAsyncClusterMaxCommits()});
            return Option.empty();
        }
        LOG.info("Generating clustering plan for table {}", (Object)this.config.getBasePath());
        ClusteringPlanStrategy strategy = (ClusteringPlanStrategy)ReflectionUtils.loadClass((String)ClusteringPlanStrategy.checkAndGetClusteringPlanStrategy(this.config), (Class[])new Class[]{HoodieTable.class, HoodieEngineContext.class, HoodieWriteConfig.class}, (Object[])new Object[]{this.table, this.context, this.config});
        Lazy partitions = Lazy.lazily(() -> this.getPartitions(strategy, TableServiceType.CLUSTER));
        return strategy.generateClusteringPlan(this, (Lazy<List<String>>)partitions);
    }

    @Override
    public Option<HoodieClusteringPlan> execute() {
        Option<HoodieClusteringPlan> planOption = this.createClusteringPlan();
        if (planOption.isPresent()) {
            String action = TimelineLayoutVersion.LAYOUT_VERSION_2.equals((Object)this.table.getMetaClient().getTimelineLayoutVersion()) ? "clustering" : "replacecommit";
            HoodieInstant clusteringInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, action, this.instantTime);
            HoodieRequestedReplaceMetadata requestedReplaceMetadata = HoodieRequestedReplaceMetadata.newBuilder().setOperationType(WriteOperationType.CLUSTER.name()).setExtraMetadata((Map)this.extraMetadata.orElse(Collections.emptyMap())).setClusteringPlan((HoodieClusteringPlan)planOption.get()).build();
            this.table.getActiveTimeline().saveToPendingClusterCommit(clusteringInstant, requestedReplaceMetadata);
        }
        return planOption;
    }
}

