/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.cluster.strategy;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMemoryConfig;
import org.apache.hudi.common.config.HoodieReaderConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.engine.ReaderContextFactory;
import org.apache.hudi.common.model.BaseFile;
import org.apache.hudi.common.model.ClusteringOperation;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.read.HoodieFileGroupReader;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieClusteringException;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.utils.SerDeHelper;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;

public abstract class ClusteringExecutionStrategy<T, I, K, O>
implements Serializable {
    private final HoodieTable<T, I, K, O> hoodieTable;
    private final transient HoodieEngineContext engineContext;
    protected HoodieWriteConfig writeConfig;
    protected final HoodieRecord.HoodieRecordType recordType;
    protected final Schema readerSchemaWithMetaFields;

    public ClusteringExecutionStrategy(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        this.writeConfig = writeConfig;
        this.hoodieTable = table;
        this.engineContext = engineContext;
        this.recordType = table.getConfig().getRecordMerger().getRecordType();
        this.readerSchemaWithMetaFields = HoodieAvroUtils.addMetadataFields((Schema)new Schema.Parser().parse(writeConfig.getSchema()));
    }

    public abstract HoodieWriteMetadata<O> performClustering(HoodieClusteringPlan var1, Schema var2, String var3);

    protected HoodieTable<T, I, K, O> getHoodieTable() {
        return this.hoodieTable;
    }

    protected HoodieEngineContext getEngineContext() {
        return this.engineContext;
    }

    protected HoodieWriteConfig getWriteConfig() {
        return this.writeConfig;
    }

    protected ClosableIterator<HoodieRecord<T>> getRecordIterator(ReaderContextFactory<T> readerContextFactory, ClusteringOperation operation, String instantTime, long maxMemory) {
        TypedProperties props = this.getReaderProperties(maxMemory);
        HoodieTable<T, I, K, O> table = this.getHoodieTable();
        FileSlice fileSlice = this.clusteringOperationToFileSlice(table.getMetaClient().getBasePath().toString(), operation);
        boolean usePosition = this.getWriteConfig().getBooleanOrDefault(HoodieReaderConfig.MERGE_USE_RECORD_POSITIONS);
        boolean enableLogBlocksScan = this.getWriteConfig().enableOptimizedLogBlocksScan();
        Option internalSchema = SerDeHelper.fromJson((String)this.getWriteConfig().getInternalSchema());
        try {
            return ClusteringExecutionStrategy.getFileGroupReader(table.getMetaClient(), fileSlice, this.readerSchemaWithMetaFields, (Option<InternalSchema>)internalSchema, readerContextFactory, instantTime, props, usePosition, enableLogBlocksScan).getClosableHoodieRecordIterator();
        }
        catch (IOException e) {
            throw new HoodieClusteringException("Error reading file slices", (Throwable)e);
        }
    }

    protected TypedProperties getReaderProperties(long maxMemory) {
        HoodieWriteConfig config = this.getWriteConfig();
        TypedProperties props = new TypedProperties();
        props.setProperty(HoodieMemoryConfig.SPILLABLE_MAP_BASE_PATH.key(), config.getSpillableMapBasePath());
        props.setProperty(HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.key(), config.getCommonConfig().getSpillableDiskMapType().toString());
        props.setProperty(HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.key(), Boolean.toString(config.getCommonConfig().isBitCaskDiskMapCompressionEnabled()));
        props.setProperty(HoodieMemoryConfig.MAX_MEMORY_FOR_MERGE.key(), Long.toString(maxMemory));
        return props;
    }

    protected FileSlice clusteringOperationToFileSlice(String basePath, ClusteringOperation clusteringOperation) {
        Option baseFile;
        String partitionPath = clusteringOperation.getPartitionPath();
        if (!StringUtils.isNullOrEmpty((String)clusteringOperation.getDataFilePath())) {
            BaseFile bootstrapFile = StringUtils.isNullOrEmpty((String)clusteringOperation.getBootstrapFilePath()) ? null : new BaseFile(new StoragePath(basePath, clusteringOperation.getBootstrapFilePath()).toString());
            baseFile = Option.of((Object)new HoodieBaseFile(new StoragePath(basePath, clusteringOperation.getDataFilePath()).toString(), bootstrapFile));
        } else {
            baseFile = Option.empty();
        }
        List<HoodieLogFile> logFiles = clusteringOperation.getDeltaFilePaths().stream().map(path -> new StoragePath(basePath, path)).map(HoodieLogFile::new).collect(Collectors.toList());
        ValidationUtils.checkState((!baseFile.isEmpty() || !logFiles.isEmpty() ? 1 : 0) != 0, () -> "Both base file and log files are missing from this clustering operation " + clusteringOperation);
        String baseInstantTime = (String)baseFile.map(HoodieBaseFile::getCommitTime).orElseGet(() -> ((HoodieLogFile)logFiles.get(0)).getDeltaCommitTime());
        FileSlice fileSlice = new FileSlice(partitionPath, baseInstantTime, clusteringOperation.getFileId());
        baseFile.ifPresent(arg_0 -> ((FileSlice)fileSlice).setBaseFile(arg_0));
        logFiles.forEach(arg_0 -> ((FileSlice)fileSlice).addLogFile(arg_0));
        return fileSlice;
    }

    protected static <R> HoodieFileGroupReader<R> getFileGroupReader(HoodieTableMetaClient metaClient, FileSlice fileSlice, Schema readerSchema, Option<InternalSchema> internalSchemaOption, ReaderContextFactory<R> readerContextFactory, String instantTime, TypedProperties properties, boolean usePosition, boolean enableLogBlocksScan) {
        HoodieReaderContext readerContext = readerContextFactory.getContext();
        return HoodieFileGroupReader.newBuilder().withReaderContext(readerContext).withHoodieTableMetaClient(metaClient).withLatestCommitTime(instantTime).withFileSlice(fileSlice).withDataSchema(readerSchema).withRequestedSchema(readerSchema).withInternalSchema(internalSchemaOption).withShouldUseRecordPosition(usePosition).withEnableOptimizedLogBlockScan(enableLogBlocksScan).withProps(properties).build();
    }
}

