/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.IOException;
import java.util.List;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hudi.avro.AvroSchemaCache;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.function.SerializableFunctionUnchecked;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.read.BufferedRecord;
import org.apache.hudi.common.table.read.BufferedRecordMerger;
import org.apache.hudi.common.table.read.BufferedRecordMergerFactory;
import org.apache.hudi.common.table.read.BufferedRecords;
import org.apache.hudi.common.table.read.DeleteContext;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.common.util.HoodieTimer;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieUpsertException;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.HoodieWriteMetadata;
import org.apache.hudi.table.action.commit.BaseCommitActionExecutor;
import org.apache.hudi.table.action.commit.ParallelismHelper;

public abstract class BaseWriteHelper<T, I, K, O, R>
extends ParallelismHelper<I> {
    protected BaseWriteHelper(SerializableFunctionUnchecked<I, Integer> partitionNumberExtractor) {
        super(partitionNumberExtractor);
    }

    public HoodieWriteMetadata<O> write(String instantTime, I inputRecords, HoodieEngineContext context, HoodieTable<T, I, K, O> table, boolean shouldCombine, int configuredShuffleParallelism, BaseCommitActionExecutor<T, I, K, O, R> executor, WriteOperationType operationType) {
        try {
            I dedupedRecords;
            HoodieTimer sourceReadAndIndexTimer = HoodieTimer.start();
            I taggedRecords = dedupedRecords = this.combineOnCondition(shouldCombine, inputRecords, configuredShuffleParallelism, table);
            if (table.getIndex().requiresTagging(operationType)) {
                context.setJobStatus(this.getClass().getSimpleName(), "Tagging: " + table.getConfig().getTableName());
                taggedRecords = this.tag(dedupedRecords, context, table);
            }
            HoodieWriteMetadata<O> result = executor.execute(taggedRecords, (Option<HoodieTimer>)Option.of((Object)sourceReadAndIndexTimer));
            return result;
        }
        catch (Throwable e) {
            if (e instanceof HoodieUpsertException) {
                throw (HoodieUpsertException)((Object)e);
            }
            throw new HoodieUpsertException("Failed to upsert for commit time " + instantTime, e);
        }
    }

    protected abstract I tag(I var1, HoodieEngineContext var2, HoodieTable<T, I, K, O> var3);

    public I combineOnCondition(boolean condition, I records, int configuredParallelism, HoodieTable<T, I, K, O> table) {
        int targetParallelism = this.deduceShuffleParallelism(records, configuredParallelism);
        return condition ? this.deduplicateRecords(records, table, targetParallelism) : records;
    }

    public I deduplicateRecords(I records, HoodieTable<T, I, K, O> table, int parallelism) {
        HoodieReaderContext readerContext = table.getContext().getReaderContextFactoryForWrite(table.getMetaClient(), table.getConfig().getRecordMerger().getRecordType(), table.getConfig().getProps()).getContext();
        HoodieTableConfig tableConfig = table.getMetaClient().getTableConfig();
        readerContext.initRecordMergerForIngestion(table.getConfig().getProps());
        List orderingFieldNames = HoodieRecordUtils.getOrderingFieldNames((RecordMergeMode)readerContext.getMergeMode(), (HoodieTableMetaClient)table.getMetaClient());
        Schema recordSchema = StringUtils.nonEmpty((String)table.getConfig().getPartialUpdateSchema()) ? new Schema.Parser().parse(table.getConfig().getPartialUpdateSchema()) : new Schema.Parser().parse(table.getConfig().getWriteSchema());
        recordSchema = AvroSchemaCache.intern((Schema)recordSchema);
        TypedProperties mergedProperties = readerContext.getMergeProps(table.getConfig().getProps());
        BufferedRecordMerger bufferedRecordMerger = BufferedRecordMergerFactory.create((HoodieReaderContext)readerContext, (RecordMergeMode)readerContext.getMergeMode(), (boolean)false, (Option)readerContext.getRecordMerger().map(HoodieRecordUtils::mergerToPreCombineMode), (Option)Option.ofNullable((Object)table.getConfig().getPayloadClass()), (Schema)recordSchema, (TypedProperties)mergedProperties, (Option)tableConfig.getPartialUpdateMode());
        return this.deduplicateRecords(records, table.getIndex(), parallelism, table.getConfig().getSchema(), mergedProperties, bufferedRecordMerger, readerContext, orderingFieldNames.toArray(new String[0]));
    }

    public abstract I deduplicateRecords(I var1, HoodieIndex<?, ?> var2, int var3, String var4, TypedProperties var5, BufferedRecordMerger<T> var6, HoodieReaderContext<T> var7, String[] var8);

    protected static <T> HoodieRecord<T> reduceRecords(TypedProperties props, BufferedRecordMerger<T> recordMerger, String[] orderingFieldNames, HoodieRecord<T> previous, HoodieRecord<T> next, Schema schema, RecordContext<T> recordContext, DeleteContext deleteContext) {
        try {
            BufferedRecord newBufferedRecord = BufferedRecords.fromHoodieRecord(next, (Schema)schema, recordContext, (Properties)props, (String[])orderingFieldNames, (DeleteContext)deleteContext);
            BufferedRecord oldBufferedRecord = BufferedRecords.fromHoodieRecord(previous, (Schema)schema, recordContext, (Properties)props, (String[])orderingFieldNames, (DeleteContext)deleteContext);
            Option merged = recordMerger.deltaMerge(newBufferedRecord, oldBufferedRecord);
            HoodieRecord reducedRecord = (HoodieRecord)merged.map(bufferedRecord -> recordContext.constructHoodieRecord(bufferedRecord, next.getPartitionPath())).orElse(previous);
            boolean choosePrevious = merged.isEmpty();
            HoodieKey reducedKey = choosePrevious ? previous.getKey() : next.getKey();
            return reducedRecord.newInstance(reducedKey);
        }
        catch (IOException e) {
            throw new HoodieException(String.format("Error to merge two records, %s, %s", previous, next), (Throwable)e);
        }
    }
}

