/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.commit;

import java.io.Serializable;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.SerializableSchema;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.engine.RecordContext;
import org.apache.hudi.common.function.SerializableBiFunction;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.table.read.BufferedRecordMerger;
import org.apache.hudi.common.table.read.DeleteContext;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.commit.BaseWriteHelper;

public class HoodieWriteHelper<T, R>
extends BaseWriteHelper<T, HoodieData<HoodieRecord<T>>, HoodieData<HoodieKey>, HoodieData<WriteStatus>, R> {
    private HoodieWriteHelper() {
        super(HoodieData::deduceNumPartitions);
    }

    public static HoodieWriteHelper newInstance() {
        return WriteHelperHolder.HOODIE_WRITE_HELPER;
    }

    @Override
    protected HoodieData<HoodieRecord<T>> tag(HoodieData<HoodieRecord<T>> dedupedRecords, HoodieEngineContext context, HoodieTable<T, HoodieData<HoodieRecord<T>>, HoodieData<HoodieKey>, HoodieData<WriteStatus>> table) {
        return table.getIndex().tagLocation(dedupedRecords, context, table);
    }

    @Override
    public HoodieData<HoodieRecord<T>> deduplicateRecords(HoodieData<HoodieRecord<T>> records, HoodieIndex<?, ?> index, int parallelism, String schemaStr, TypedProperties props, BufferedRecordMerger<T> recordMerger, HoodieReaderContext<T> readerContext, String[] orderingFieldNames) {
        boolean isIndexingGlobal = index.isGlobal();
        SerializableSchema schema = new SerializableSchema(schemaStr);
        RecordContext recordContext = readerContext.getRecordContext();
        DeleteContext deleteContext = DeleteContext.fromRecordSchema((Properties)props, (Schema)schema.get());
        return records.mapToPair((SerializablePairFunction & Serializable)record -> {
            HoodieKey hoodieKey = record.getKey();
            Object key = isIndexingGlobal ? hoodieKey.getRecordKey() : hoodieKey;
            return Pair.of((Object)key, (Object)record.copy());
        }).reduceByKey((SerializableBiFunction & Serializable)(previous, next) -> HoodieWriteHelper.reduceRecords(props, recordMerger, orderingFieldNames, previous, next, schema.get(), recordContext, deleteContext), parallelism).map(Pair::getRight);
    }

    private static class WriteHelperHolder {
        private static final HoodieWriteHelper HOODIE_WRITE_HELPER = new HoodieWriteHelper();

        private WriteHelperHolder() {
        }
    }
}

