/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.hudi.avro.HoodieAvroReaderContext;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.data.HoodieData;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.engine.ReaderContextFactory;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.function.SerializableFunction;
import org.apache.hudi.common.model.CompactionOperation;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.CollectionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.FileGroupReaderBasedAppendHandle;
import org.apache.hudi.io.HoodieMergeHandle;
import org.apache.hudi.io.HoodieMergeHandleFactory;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.compact.CompactHelpers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HoodieCompactor<T, I, K, O>
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieCompactor.class);

    public abstract void preCompact(HoodieTable var1, HoodieTimeline var2, WriteOperationType var3, String var4);

    public abstract void maybePersist(HoodieData<WriteStatus> var1, HoodieEngineContext var2, HoodieWriteConfig var3, String var4);

    public HoodieData<WriteStatus> compact(HoodieEngineContext context, WriteOperationType operationType, HoodieCompactionPlan compactionPlan, HoodieTable table, HoodieWriteConfig config, String compactionInstantTime) {
        HoodieInstant instant;
        if (compactionPlan == null || compactionPlan.getOperations() == null || compactionPlan.getOperations().isEmpty()) {
            return context.emptyHoodieData();
        }
        HoodieActiveTimeline timeline = table.getActiveTimeline();
        if (operationType == WriteOperationType.LOG_COMPACT) {
            instant = table.getMetaClient().getInstantGenerator().getLogCompactionRequestedInstant(compactionInstantTime);
            timeline.transitionLogCompactionRequestedToInflight(instant);
        } else {
            instant = table.getMetaClient().getInstantGenerator().getCompactionRequestedInstant(compactionInstantTime);
            timeline.transitionCompactionRequestedToInflight(instant);
        }
        table.getMetaClient().reloadActiveTimeline();
        HoodieTableMetaClient metaClient = table.getMetaClient();
        TableSchemaResolver schemaResolver = new TableSchemaResolver(metaClient);
        try {
            if (StringUtils.isNullOrEmpty((String)config.getInternalSchema())) {
                Schema readerSchema = schemaResolver.getTableAvroSchema(false);
                config.setSchema(readerSchema.toString());
            }
        }
        catch (Exception readerSchema) {
            // empty catch block
        }
        List operations = compactionPlan.getOperations().stream().map(CompactionOperation::convertFromAvroRecordInstance).collect(Collectors.toList());
        LOG.info("Compactor compacting {} fileGroups", (Object)operations.size());
        String maxInstantTime = this.getMaxInstantTime(metaClient);
        context.setJobStatus(this.getClass().getSimpleName(), "Compacting file slices: " + config.getTableName());
        TaskContextSupplier taskContextSupplier = table.getTaskContextSupplier();
        Option<InstantRange> instantRange = CompactHelpers.getInstance().getInstantRange(metaClient);
        if (operationType == WriteOperationType.LOG_COMPACT) {
            return context.parallelize(operations).map((SerializableFunction & Serializable)operation -> this.logCompact(config, (CompactionOperation)operation, compactionInstantTime, instantRange, table, taskContextSupplier)).flatMap(List::iterator);
        }
        ReaderContextFactory readerContextFactory = !metaClient.isMetadataTable() ? context.getReaderContextFactory(metaClient) : context.getReaderContextFactoryForWrite(metaClient, HoodieRecord.HoodieRecordType.AVRO, config.getProps());
        return context.parallelize(operations).map((SerializableFunction & Serializable)operation -> this.compact(config, (CompactionOperation)operation, compactionInstantTime, readerContextFactory.getContext(), table, maxInstantTime, taskContextSupplier)).flatMap(List::iterator);
    }

    public List<WriteStatus> compact(HoodieWriteConfig writeConfig, CompactionOperation operation, String instantTime, HoodieReaderContext hoodieReaderContext, HoodieTable table, String maxInstantTime, TaskContextSupplier taskContextSupplier) throws IOException {
        HoodieMergeHandle mergeHandle = HoodieMergeHandleFactory.create(writeConfig, instantTime, table, operation, taskContextSupplier, hoodieReaderContext, maxInstantTime, this.getEngineRecordType());
        mergeHandle.doMerge();
        return mergeHandle.close();
    }

    public List<WriteStatus> logCompact(HoodieWriteConfig writeConfig, CompactionOperation operation, String instantTime, Option<InstantRange> instantRange, HoodieTable table, TaskContextSupplier taskContextSupplier) throws IOException {
        HoodieAvroReaderContext readerContext = new HoodieAvroReaderContext(table.getStorageConf(), table.getMetaClient().getTableConfig(), instantRange, Option.empty(), writeConfig.getProps());
        FileGroupReaderBasedAppendHandle appendHandle = new FileGroupReaderBasedAppendHandle(writeConfig, instantTime, table, operation, taskContextSupplier, readerContext);
        appendHandle.doAppend();
        return appendHandle.close();
    }

    public String getMaxInstantTime(HoodieTableMetaClient metaClient) {
        String maxInstantTime = ((HoodieInstant)metaClient.getActiveTimeline().getTimelineOfActions(CollectionUtils.createSet((Object[])new String[]{"commit", "rollback", "deltacommit"})).filterCompletedInstants().lastInstant().get()).requestedTime();
        return maxInstantTime;
    }

    protected abstract HoodieRecord.HoodieRecordType getEngineRecordType();
}

