/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.compact.plan.generators;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.avro.model.HoodieCompactionStrategy;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.TableServiceType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.log.HoodieLogBlockMetadataScanner;
import org.apache.hudi.common.table.log.InstantRange;
import org.apache.hudi.common.util.CompactionUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseTableServicePlanActionExecutor;
import org.apache.hudi.table.action.compact.plan.generators.BaseHoodieCompactionPlanGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieLogCompactionPlanGenerator<T extends HoodieRecordPayload, I, K, O>
extends BaseHoodieCompactionPlanGenerator<T, I, K, O> {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieLogCompactionPlanGenerator.class);
    private final HoodieCompactionStrategy compactionStrategy = HoodieCompactionStrategy.newBuilder().setStrategyParams(this.getStrategyParams()).setCompactorClassName("org.apache.hudi.table.action.compact.LogCompactionExecutionHelper").build();

    public HoodieLogCompactionPlanGenerator(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig, BaseTableServicePlanActionExecutor executor) {
        super(table, engineContext, writeConfig, executor);
    }

    @Override
    protected HoodieCompactionPlan getCompactionPlan(HoodieTableMetaClient metaClient, List<HoodieCompactionOperation> operations, Pair<List<String>, List<String>> partitionPair) {
        return HoodieCompactionPlan.newBuilder().setOperations(operations).setVersion(CompactionUtils.LATEST_COMPACTION_METADATA_VERSION).setStrategy(this.compactionStrategy).setMissingSchedulePartitions((List)partitionPair.getRight()).setPreserveHoodieMetadata(Boolean.valueOf(true)).build();
    }

    @Override
    protected List<String> getPartitions() {
        return this.executor.getPartitions(this.compactionStrategy, TableServiceType.LOG_COMPACT);
    }

    @Override
    protected boolean filterFileSlice(FileSlice fileSlice, String lastCompletedInstantTime, Set<HoodieFileGroupId> pendingFileGroupIds, Option<InstantRange> instantRange) {
        return super.filterFileSlice(fileSlice, lastCompletedInstantTime, pendingFileGroupIds, instantRange) && this.isFileSliceEligibleForLogCompaction(fileSlice, lastCompletedInstantTime, instantRange);
    }

    @Override
    protected boolean filterLogCompactionOperations() {
        return true;
    }

    private boolean isFileSliceEligibleForLogCompaction(FileSlice fileSlice, String maxInstantTime, Option<InstantRange> instantRange) {
        LOG.info("Checking if fileId {} and partition {} eligible for log compaction.", (Object)fileSlice.getFileId(), (Object)fileSlice.getPartitionPath());
        HoodieTableMetaClient metaClient = this.hoodieTable.getMetaClient();
        long numLogFiles = fileSlice.getLogFiles().count();
        if (numLogFiles >= (long)this.writeConfig.getLogCompactionBlocksThreshold()) {
            LOG.info("Total logs files ({}) is greater than log blocks threshold is {}", (Object)numLogFiles, (Object)this.writeConfig.getLogCompactionBlocksThreshold());
            return true;
        }
        HoodieLogBlockMetadataScanner scanner = new HoodieLogBlockMetadataScanner(metaClient, fileSlice.getLogFiles().sorted(HoodieLogFile.getLogFileComparator()).collect(Collectors.toList()), this.writeConfig.getMaxDFSStreamBufferSize(), maxInstantTime, instantRange);
        int totalBlocks = scanner.getCurrentInstantLogBlocks().size();
        LOG.info("Total blocks seen are {}, log blocks threshold is {}", (Object)totalBlocks, (Object)this.writeConfig.getLogCompactionBlocksThreshold());
        return totalBlocks >= this.writeConfig.getLogCompactionBlocksThreshold();
    }
}

