/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.restore;

import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.client.transaction.TransactionManager;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieRollbackException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.restore.BaseRestoreActionExecutor;
import org.apache.hudi.table.action.rollback.CopyOnWriteRollbackActionExecutor;

public class CopyOnWriteRestoreActionExecutor<T, I, K, O>
extends BaseRestoreActionExecutor<T, I, K, O> {
    public CopyOnWriteRestoreActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable table, String instantTime, String savepointToRestoreTimestamp) {
        super(context, config, table, instantTime, savepointToRestoreTimestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HoodieRollbackMetadata rollbackInstant(HoodieInstant instantToRollback) {
        String newInstantTime;
        if (!instantToRollback.getAction().equals("commit") && !ClusteringUtils.isClusteringOrReplaceCommitAction((String)instantToRollback.getAction())) {
            throw new HoodieRollbackException("Unsupported action in rollback instant:" + instantToRollback);
        }
        try (TransactionManager transactionManager = new TransactionManager(this.config, this.table.getStorage());){
            this.table.getMetaClient().reloadActiveTimeline();
            transactionManager.beginStateChange((Option<HoodieInstant>)Option.empty(), (Option<HoodieInstant>)Option.empty());
            try {
                newInstantTime = this.table.getMetaClient().createNewInstantTime(false);
                this.table.scheduleRollback(this.context, newInstantTime, instantToRollback, false, false, true);
            }
            finally {
                transactionManager.endStateChange((Option<HoodieInstant>)Option.empty());
            }
        }
        this.table.getMetaClient().reloadActiveTimeline();
        CopyOnWriteRollbackActionExecutor rollbackActionExecutor = new CopyOnWriteRollbackActionExecutor(this.context, this.config, this.table, newInstantTime, instantToRollback, true, true, false);
        return rollbackActionExecutor.execute();
    }
}

