/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.restore;

import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.client.transaction.TransactionManager;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.restore.BaseRestoreActionExecutor;
import org.apache.hudi.table.action.rollback.MergeOnReadRollbackActionExecutor;

public class MergeOnReadRestoreActionExecutor<T, I, K, O>
extends BaseRestoreActionExecutor<T, I, K, O> {
    public MergeOnReadRestoreActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, String savepointToRestoreTimestamp) {
        super(context, config, table, instantTime, savepointToRestoreTimestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected HoodieRollbackMetadata rollbackInstant(HoodieInstant instantToRollback) {
        String newInstantTime;
        switch (instantToRollback.getAction()) {
            case "commit": 
            case "deltacommit": 
            case "compaction": 
            case "replacecommit": 
            case "clustering": {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid action name " + instantToRollback.getAction());
            }
        }
        try (TransactionManager transactionManager = new TransactionManager(this.config, this.table.getStorage());){
            this.table.getMetaClient().reloadActiveTimeline();
            transactionManager.beginStateChange((Option<HoodieInstant>)Option.empty(), (Option<HoodieInstant>)Option.empty());
            try {
                newInstantTime = this.table.getMetaClient().createNewInstantTime(false);
                this.table.scheduleRollback(this.context, newInstantTime, instantToRollback, false, false, true);
            }
            finally {
                transactionManager.endStateChange((Option<HoodieInstant>)Option.empty());
            }
        }
        this.table.getMetaClient().reloadActiveTimeline();
        MergeOnReadRollbackActionExecutor rollbackActionExecutor = new MergeOnReadRollbackActionExecutor(this.context, this.config, this.table, newInstantTime, instantToRollback, true, true, false);
        return rollbackActionExecutor.execute();
    }
}

