/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.InstantComparator;

public class RestoreInstantComparatorFactory {
    private static final Set<String> COMPACTION_ACTIONS = Stream.of("compaction", "commit").collect(Collectors.toSet());

    public static Comparator<HoodieInstant> createComparator(HoodieTableMetaClient metaClient) {
        InstantComparator instantComparator = metaClient.getTimelineLayout().getInstantComparator();
        HoodieTableType tableType = metaClient.getTableType();
        if (tableType == HoodieTableType.COPY_ON_WRITE) {
            return (o1, o2) -> instantComparator.completionTimeOrderedComparator().compare(o1, o2);
        }
        return (o1, o2) -> {
            if (COMPACTION_ACTIONS.contains(o1.getAction()) || COMPACTION_ACTIONS.contains(o2.getAction())) {
                return instantComparator.requestedTimeOrderedComparator().compare(o1, o2);
            }
            return instantComparator.completionTimeOrderedComparator().compare(o1, o2);
        };
    }
}

