/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.rollback;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieInstantInfo;
import org.apache.hudi.avro.model.HoodieRestorePlan;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.CompletionTimeQueryView;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.util.ClusteringUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseActionExecutor;
import org.apache.hudi.table.action.rollback.RestoreInstantComparatorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestorePlanActionExecutor<T, I, K, O>
extends BaseActionExecutor<T, I, K, O, Option<HoodieRestorePlan>> {
    private static final Logger LOG = LoggerFactory.getLogger(RestorePlanActionExecutor.class);
    public static final Integer RESTORE_PLAN_VERSION_1 = 1;
    public static final Integer RESTORE_PLAN_VERSION_2;
    public static final Integer LATEST_RESTORE_PLAN_VERSION;
    private final String savepointToRestoreTimestamp;

    public RestorePlanActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, String savepointToRestoreTimestamp) {
        super(context, config, table, instantTime);
        this.savepointToRestoreTimestamp = savepointToRestoreTimestamp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Option<HoodieRestorePlan> execute() {
        HoodieInstant restoreInstant = this.instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, "restore", this.instantTime);
        HoodieTableMetaClient metaClient = this.table.getMetaClient();
        try (CompletionTimeQueryView completionTimeQueryView = metaClient.getTableFormat().getTimelineFactory().createCompletionTimeQueryView(metaClient);){
            List instantsToRollback;
            if (this.table.getMetaClient().isMetadataTable() && RestorePlanActionExecutor.isMetadataTableRecreatedDuringRestore(metaClient)) {
                instantsToRollback = Collections.emptyList();
            } else {
                List pendingClusteringInstantsToRollback = this.table.getActiveTimeline().filterPendingReplaceOrClusteringTimeline().filter(instant -> ClusteringUtils.isClusteringInstant((HoodieTimeline)this.table.getActiveTimeline(), (HoodieInstant)instant, (InstantGenerator)this.instantGenerator)).getReverseOrderedInstants().filter(instant -> InstantComparison.GREATER_THAN.test(instant.requestedTime(), this.savepointToRestoreTimestamp)).collect(Collectors.toList());
                String completionTime = this.savepointToRestoreTimestamp.equals("00000000000000") ? this.savepointToRestoreTimestamp : (String)completionTimeQueryView.getCompletionTime(this.savepointToRestoreTimestamp).orElseThrow(() -> new HoodieException("Unable to find completion time for instant: " + this.savepointToRestoreTimestamp));
                Predicate<HoodieInstant> instantFilter = this.constructInstantFilter(completionTime);
                List commitInstantsToRollback = this.table.getActiveTimeline().getWriteTimeline().getReverseOrderedInstantsByCompletionTime().filter(instantFilter).filter(instant -> !pendingClusteringInstantsToRollback.contains(instant)).collect(Collectors.toList());
                instantsToRollback = Stream.concat(pendingClusteringInstantsToRollback.stream(), commitInstantsToRollback.stream()).map(entry -> new HoodieInstantInfo(entry.requestedTime(), entry.getAction())).collect(Collectors.toList());
            }
            HoodieRestorePlan restorePlan = new HoodieRestorePlan(instantsToRollback, LATEST_RESTORE_PLAN_VERSION, this.savepointToRestoreTimestamp);
            this.table.getActiveTimeline().saveToRestoreRequested(restoreInstant, restorePlan);
            this.table.getMetaClient().reloadActiveTimeline();
            LOG.info("Requesting Restore with instant time {}", (Object)restoreInstant);
            Option option = Option.of((Object)restorePlan);
            return option;
        }
        catch (Exception e) {
            throw new HoodieException("Unable to restore to instant: " + this.savepointToRestoreTimestamp, (Throwable)e);
        }
    }

    private static boolean isMetadataTableRecreatedDuringRestore(HoodieTableMetaClient metaClient) {
        return (Boolean)metaClient.getActiveTimeline().lastInstant().map(instant -> instant.requestedTime().startsWith("00000000000000")).orElse((Object)true);
    }

    private Predicate<HoodieInstant> constructInstantFilter(String completionTime) {
        HoodieInstant instantToRestoreTo = this.table.getMetaClient().getInstantGenerator().createNewInstant(HoodieInstant.State.COMPLETED, "restore", this.savepointToRestoreTimestamp, completionTime);
        Comparator<HoodieInstant> comparator = RestoreInstantComparatorFactory.createComparator(this.table.getMetaClient());
        return instant -> comparator.compare((HoodieInstant)instant, instantToRestoreTo) > 0;
    }

    static {
        LATEST_RESTORE_PLAN_VERSION = RESTORE_PLAN_VERSION_2 = Integer.valueOf(2);
    }
}

