/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.savepoint;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.function.SerializablePairFunction;
import org.apache.hudi.common.model.HoodieBaseFile;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.InstantComparison;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.table.view.TableFileSystemView;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.VisibleForTesting;
import org.apache.hudi.common.util.collection.ImmutablePair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.exception.HoodieSavepointException;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.BaseActionExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SavepointActionExecutor<T, I, K, O>
extends BaseActionExecutor<T, I, K, O, HoodieSavepointMetadata> {
    private static final Logger LOG = LoggerFactory.getLogger(SavepointActionExecutor.class);
    private final String user;
    private final String comment;

    public SavepointActionExecutor(HoodieEngineContext context, HoodieWriteConfig config, HoodieTable<T, I, K, O> table, String instantTime, String user, String comment) {
        super(context, config, table, instantTime);
        this.user = user;
        this.comment = comment;
    }

    @Override
    public HoodieSavepointMetadata execute() {
        if (!this.table.getCompletedCommitsTimeline().containsInstant(this.instantTime)) {
            throw new HoodieSavepointException("Could not savepoint non-existing commit " + this.instantTime);
        }
        try {
            Map latestFilesMap;
            String lastCommitRetained = this.getLastCommitRetained();
            ValidationUtils.checkArgument((boolean)InstantComparison.compareTimestamps((String)this.instantTime, (BiPredicate)InstantComparison.GREATER_THAN_OR_EQUALS, (String)lastCommitRetained), () -> "Could not savepoint commit " + this.instantTime + " as this is beyond the lookup window " + lastCommitRetained);
            this.context.setJobStatus(this.getClass().getSimpleName(), "Collecting latest files for savepoint " + this.instantTime + " " + this.table.getConfig().getTableName());
            TableFileSystemView.SliceView view = this.table.getSliceView();
            if (this.table.getMetaClient().getTableConfig().isMetadataTableAvailable()) {
                latestFilesMap = view.getAllLatestFileSlicesBeforeOrOn(this.instantTime).entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
                    ArrayList latestFiles = new ArrayList();
                    ((Stream)entry.getValue()).forEach(fileSlice -> {
                        if (fileSlice.getBaseFile().isPresent()) {
                            latestFiles.add(((HoodieBaseFile)fileSlice.getBaseFile().get()).getFileName());
                        }
                        latestFiles.addAll(fileSlice.getLogFiles().map(HoodieLogFile::getFileName).collect(Collectors.toList()));
                    });
                    return latestFiles;
                }));
            } else {
                List partitions = FSUtils.getAllPartitionPaths((HoodieEngineContext)this.context, (HoodieTableMetaClient)this.table.getMetaClient(), (HoodieMetadataConfig)this.config.getMetadataConfig());
                latestFilesMap = this.context.mapToPair(partitions, (SerializablePairFunction & Serializable)partitionPath -> {
                    LOG.info("Collecting latest files in partition path {}", partitionPath);
                    ArrayList latestFiles = new ArrayList();
                    view.getLatestFileSlicesBeforeOrOn(partitionPath, this.instantTime, true).forEach(fileSlice -> {
                        if (fileSlice.getBaseFile().isPresent()) {
                            latestFiles.add(((HoodieBaseFile)fileSlice.getBaseFile().get()).getFileName());
                        }
                        latestFiles.addAll(fileSlice.getLogFiles().map(HoodieLogFile::getFileName).collect(Collectors.toList()));
                    });
                    return new ImmutablePair(partitionPath, latestFiles);
                }, null);
            }
            HoodieSavepointMetadata metadata = TimelineMetadataUtils.convertSavepointMetadata((String)this.user, (String)this.comment, latestFilesMap);
            this.table.getActiveTimeline().createNewInstant(this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "savepoint", this.instantTime));
            this.table.getActiveTimeline().saveAsComplete(true, this.instantGenerator.createNewInstant(HoodieInstant.State.INFLIGHT, "savepoint", this.instantTime), Option.of((Object)metadata), savepointCompletedInstant -> this.table.getMetaClient().getTableFormat().savepoint(savepointCompletedInstant, this.table.getContext(), this.table.getMetaClient(), this.table.getViewManager()));
            LOG.info("Savepoint {} created", (Object)this.instantTime);
            return metadata;
        }
        catch (HoodieIOException e) {
            throw new HoodieSavepointException("Failed to savepoint " + this.instantTime, e);
        }
    }

    @VisibleForTesting
    String getLastCommitRetained() {
        Option cleanInstant = this.table.getCleanTimeline().lastInstant();
        if (cleanInstant.isEmpty()) {
            return ((HoodieInstant)this.table.getCompletedCommitsTimeline().firstInstant().get()).requestedTime();
        }
        return (String)cleanInstant.map(instant -> {
            try {
                if (instant.isCompleted()) {
                    return this.table.getActiveTimeline().readCleanMetadata(instant).getEarliestCommitToRetain();
                }
                return this.table.getActiveTimeline().readCleanerPlan(this.instantGenerator.createNewInstant(HoodieInstant.State.REQUESTED, instant.getAction(), instant.requestedTime())).getEarliestInstantToRetain().getTimestamp();
            }
            catch (IOException e) {
                throw new HoodieSavepointException("Failed to savepoint " + this.instantTime, e);
            }
        }).orElseGet(() -> (String)this.table.getActiveTimeline().getWriteTimeline().filterCompletedInstants().filter(instant -> InstantComparison.compareTimestamps((String)instant.requestedTime(), (BiPredicate)InstantComparison.LESSER_THAN_OR_EQUALS, (String)((HoodieInstant)cleanInstant.get()).requestedTime())).lastInstant().map(HoodieInstant::requestedTime).orElse((Object)((HoodieInstant)cleanInstant.get()).requestedTime()));
    }
}

