/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.marker;

import java.io.IOException;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.conflict.detection.DirectMarkerBasedDetectionStrategy;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.util.MarkerUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieEarlyConflictDetectionException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieStorage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleDirectMarkerBasedDetectionStrategy
extends DirectMarkerBasedDetectionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleDirectMarkerBasedDetectionStrategy.class);
    private final String basePath;
    private final boolean checkCommitConflict;
    private final Set<HoodieInstant> completedCommitInstants;
    private final long maxAllowableHeartbeatIntervalInMs;

    public SimpleDirectMarkerBasedDetectionStrategy(HoodieStorage storage, String partitionPath, String fileId, String instantTime, HoodieActiveTimeline activeTimeline, HoodieWriteConfig config) {
        super(storage, partitionPath, fileId, instantTime, activeTimeline, (HoodieConfig)config);
        this.basePath = config.getBasePath();
        this.checkCommitConflict = config.earlyConflictDetectionCheckCommitConflict();
        this.completedCommitInstants = new HashSet<HoodieInstant>(activeTimeline.getCommitsTimeline().filterCompletedInstants().getInstants());
        this.maxAllowableHeartbeatIntervalInMs = config.getHoodieClientHeartbeatIntervalInMs() * (long)config.getHoodieClientHeartbeatTolerableMisses().intValue();
    }

    public boolean hasMarkerConflict() {
        try {
            return this.checkMarkerConflict(this.basePath, this.maxAllowableHeartbeatIntervalInMs) || this.checkCommitConflict && MarkerUtils.hasCommitConflict((HoodieActiveTimeline)this.activeTimeline, Stream.of(this.fileId).collect(Collectors.toSet()), this.completedCommitInstants);
        }
        catch (IOException e) {
            LOG.error("Exception occurs during create marker file in eager conflict detection mode.", (Throwable)e);
            throw new HoodieIOException("Exception occurs during create marker file in eager conflict detection mode.", e);
        }
    }

    public void resolveMarkerConflict(String basePath, String partitionPath, String dataFileName) {
        throw new HoodieEarlyConflictDetectionException((Throwable)new ConcurrentModificationException("Early conflict detected but cannot resolve conflicts for overlapping writes"));
    }

    public void detectAndResolveConflictIfNecessary() throws HoodieEarlyConflictDetectionException {
        if (this.hasMarkerConflict()) {
            this.resolveMarkerConflict(this.basePath, this.partitionPath, this.fileId);
        }
    }
}

