/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.AWSDmsAvroPayload;
import org.apache.hudi.common.model.EventTimeAvroPayload;
import org.apache.hudi.common.model.HoodieIndexMetadata;
import org.apache.hudi.common.model.OverwriteNonDefaultsWithLatestAvroPayload;
import org.apache.hudi.common.model.PartialUpdateAvroPayload;
import org.apache.hudi.common.model.debezium.MySqlDebeziumAvroPayload;
import org.apache.hudi.common.model.debezium.PostgresDebeziumAvroPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.PartialUpdateMode;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieUpgradeDowngradeException;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.metadata.HoodieIndexVersion;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeDowngradeUtils;
import org.apache.hudi.table.upgrade.UpgradeHandler;

public class EightToNineUpgradeHandler
implements UpgradeHandler {
    private static final Set<String> PAYLOADS_MAPPED_TO_EVENT_TIME_MERGE_MODE = new HashSet<String>(Arrays.asList(EventTimeAvroPayload.class.getName(), MySqlDebeziumAvroPayload.class.getName(), PartialUpdateAvroPayload.class.getName(), PostgresDebeziumAvroPayload.class.getName()));
    private static final Set<String> PAYLOADS_MAPPED_TO_COMMIT_TIME_MERGE_MODE = new HashSet<String>(Arrays.asList(AWSDmsAvroPayload.class.getName(), OverwriteNonDefaultsWithLatestAvroPayload.class.getName()));
    public static final Set<String> BUILTIN_MERGE_STRATEGIES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("ce9acb64-bde0-424c-9b91-f6ebba25356d", "1897ef5f-18bc-4557-939c-9d6a8afd1519", "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5", "00000000-0000-0000-0000-000000000000")));

    @Override
    public UpgradeDowngrade.TableConfigChangeSet upgrade(HoodieWriteConfig config, HoodieEngineContext context, String instantTime, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        HoodieTable table = upgradeDowngradeHelper.getTable(config, context);
        HashMap<ConfigProperty, String> tablePropsToAdd = new HashMap<ConfigProperty, String>();
        HashSet<ConfigProperty> tablePropsToRemove = new HashSet<ConfigProperty>();
        HoodieTableMetaClient metaClient = table.getMetaClient();
        HoodieTableConfig tableConfig = metaClient.getTableConfig();
        if (config.enableComplexKeygenValidation() && KeyGenUtils.isComplexKeyGeneratorWithSingleRecordKeyField(tableConfig)) {
            throw new HoodieUpgradeDowngradeException(KeyGenUtils.getComplexKeygenErrorMessage("upgrade"));
        }
        Option indexMetadataOpt = metaClient.getIndexMetadata();
        if (indexMetadataOpt.isPresent()) {
            EightToNineUpgradeHandler.populateIndexVersionIfMissing((Option<HoodieIndexMetadata>)indexMetadataOpt);
            HoodieTableMetaClient.writeIndexMetadataToStorage((HoodieStorage)metaClient.getStorage(), (String)metaClient.getIndexDefinitionPath(), (HoodieIndexMetadata)((HoodieIndexMetadata)indexMetadataOpt.get()), (HoodieTableVersion)metaClient.getTableConfig().getTableVersion());
        }
        this.reconcileMergeModeConfig(tablePropsToAdd, tablePropsToRemove, tableConfig, config);
        this.reconcilePartialUpdateModeConfig(tablePropsToAdd, tableConfig, config);
        this.reconcileMergePropertiesConfig(tablePropsToAdd, tableConfig, config);
        this.reconcilePayloadClassConfig(tablePropsToAdd, tablePropsToRemove, tableConfig, config);
        this.reconcileOrderingFieldsConfig(tablePropsToAdd, tablePropsToRemove, tableConfig, config);
        return new UpgradeDowngrade.TableConfigChangeSet(tablePropsToAdd, tablePropsToRemove);
    }

    private void reconcileMergeModeConfig(Map<ConfigProperty, String> tablePropsToAdd, Set<ConfigProperty> tablePropsToRemove, HoodieTableConfig tableConfig, HoodieWriteConfig config) {
        String payloadClass = (String)tableConfig.getPayloadClassIfPresent().orElse((Object)config.getPayloadClass());
        RecordMergeMode mergeMode = tableConfig.getRecordMergeMode();
        if (mergeMode != RecordMergeMode.CUSTOM) {
            tablePropsToRemove.add(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID);
        } else if (StringUtils.isNullOrEmpty((String)payloadClass)) {
            return;
        }
        if (PAYLOADS_MAPPED_TO_COMMIT_TIME_MERGE_MODE.contains(payloadClass)) {
            tablePropsToAdd.put(HoodieTableConfig.RECORD_MERGE_MODE, RecordMergeMode.COMMIT_TIME_ORDERING.name());
            tablePropsToAdd.put(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID, "ce9acb64-bde0-424c-9b91-f6ebba25356d");
        } else if (PAYLOADS_MAPPED_TO_EVENT_TIME_MERGE_MODE.contains(payloadClass)) {
            tablePropsToAdd.put(HoodieTableConfig.RECORD_MERGE_MODE, RecordMergeMode.EVENT_TIME_ORDERING.name());
            tablePropsToAdd.put(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5");
        }
    }

    private void reconcilePayloadClassConfig(Map<ConfigProperty, String> tablePropsToAdd, Set<ConfigProperty> tablePropsToRemove, HoodieTableConfig tableConfig, HoodieWriteConfig config) {
        String payloadClass = (String)tableConfig.getPayloadClassIfPresent().orElse((Object)config.getPayloadClass());
        if (StringUtils.isNullOrEmpty((String)payloadClass)) {
            return;
        }
        if (UpgradeDowngradeUtils.PAYLOAD_CLASSES_TO_HANDLE.contains(payloadClass)) {
            tablePropsToAdd.put(HoodieTableConfig.LEGACY_PAYLOAD_CLASS_NAME, payloadClass);
            tablePropsToRemove.add(HoodieTableConfig.PAYLOAD_CLASS_NAME);
        }
    }

    private void reconcilePartialUpdateModeConfig(Map<ConfigProperty, String> tablePropsToAdd, HoodieTableConfig tableConfig, HoodieWriteConfig config) {
        String payloadClass = (String)tableConfig.getPayloadClassIfPresent().orElse((Object)config.getPayloadClass());
        if (StringUtils.isNullOrEmpty((String)payloadClass)) {
            return;
        }
        if (payloadClass.equals(OverwriteNonDefaultsWithLatestAvroPayload.class.getName()) || payloadClass.equals(PartialUpdateAvroPayload.class.getName())) {
            tablePropsToAdd.put(HoodieTableConfig.PARTIAL_UPDATE_MODE, PartialUpdateMode.IGNORE_DEFAULTS.name());
        } else if (payloadClass.equals(PostgresDebeziumAvroPayload.class.getName())) {
            tablePropsToAdd.put(HoodieTableConfig.PARTIAL_UPDATE_MODE, PartialUpdateMode.FILL_UNAVAILABLE.name());
        }
    }

    private void reconcileMergePropertiesConfig(Map<ConfigProperty, String> tablePropsToAdd, HoodieTableConfig tableConfig, HoodieWriteConfig writeConfig) {
        String payloadClass = (String)tableConfig.getPayloadClassIfPresent().orElse((Object)writeConfig.getPayloadClass());
        if (StringUtils.isNullOrEmpty((String)payloadClass)) {
            return;
        }
        if (payloadClass.equals(AWSDmsAvroPayload.class.getName())) {
            tablePropsToAdd.put(ConfigProperty.key((String)"hoodie.record.merge.property.hoodie.payload.delete.field").noDefaultValue(), "Op");
            tablePropsToAdd.put(ConfigProperty.key((String)"hoodie.record.merge.property.hoodie.payload.delete.marker").noDefaultValue(), "D");
        } else if (payloadClass.equals(PostgresDebeziumAvroPayload.class.getName())) {
            tablePropsToAdd.put(ConfigProperty.key((String)"hoodie.record.merge.property.hoodie.write.partial.update.unavailable.value").noDefaultValue(), "__debezium_unavailable_value");
            tablePropsToAdd.put(ConfigProperty.key((String)"hoodie.record.merge.property.hoodie.payload.delete.field").noDefaultValue(), "_change_operation_type");
            tablePropsToAdd.put(ConfigProperty.key((String)"hoodie.record.merge.property.hoodie.payload.delete.marker").noDefaultValue(), "d");
        } else if (payloadClass.equals(MySqlDebeziumAvroPayload.class.getName())) {
            tablePropsToAdd.put(ConfigProperty.key((String)"hoodie.record.merge.property.hoodie.payload.delete.field").noDefaultValue(), "_change_operation_type");
            tablePropsToAdd.put(ConfigProperty.key((String)"hoodie.record.merge.property.hoodie.payload.delete.marker").noDefaultValue(), "d");
        } else if (writeConfig.contains("hoodie.payload.delete.field") && writeConfig.contains("hoodie.payload.delete.marker")) {
            tablePropsToAdd.put(ConfigProperty.key((String)"hoodie.record.merge.property.hoodie.payload.delete.field").noDefaultValue(), writeConfig.getString("hoodie.payload.delete.field"));
            tablePropsToAdd.put(ConfigProperty.key((String)"hoodie.record.merge.property.hoodie.payload.delete.marker").noDefaultValue(), writeConfig.getString("hoodie.payload.delete.marker"));
        }
    }

    private void reconcileOrderingFieldsConfig(Map<ConfigProperty, String> tablePropsToAdd, Set<ConfigProperty> tablePropsToRemove, HoodieTableConfig tableConfig, HoodieWriteConfig config) {
        String payloadClass = (String)tableConfig.getPayloadClassIfPresent().orElse((Object)config.getPayloadClass());
        Option orderingFieldsOpt = MySqlDebeziumAvroPayload.class.getName().equals(payloadClass) ? Option.of((Object)"_event_bin_file,_event_pos") : (PostgresDebeziumAvroPayload.class.getName().equals(payloadClass) ? Option.of((Object)"_event_lsn") : tableConfig.getOrderingFieldsStr());
        orderingFieldsOpt.ifPresent(orderingFields -> {
            tablePropsToAdd.put(HoodieTableConfig.ORDERING_FIELDS, (String)orderingFields);
            tablePropsToRemove.add(HoodieTableConfig.PRECOMBINE_FIELD);
        });
    }

    static void populateIndexVersionIfMissing(Option<HoodieIndexMetadata> indexDefOption) {
        indexDefOption.ifPresent(idxDefs -> idxDefs.getIndexDefinitions().replaceAll((indexName, idxDef) -> {
            if (idxDef.getVersion() == null) {
                return idxDef.toBuilder().withVersion(HoodieIndexVersion.V1).build();
            }
            return idxDef;
        }));
    }
}

