/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.io.IOException;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantFileNameGenerator;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieUpgradeDowngradeException;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FiveToSixUpgradeHandler
implements UpgradeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FiveToSixUpgradeHandler.class);

    @Override
    public UpgradeDowngrade.TableConfigChangeSet upgrade(HoodieWriteConfig config, HoodieEngineContext context, String instantTime, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        HoodieTable table = upgradeDowngradeHelper.getTable(config, context);
        this.deleteCompactionRequestedFileFromAuxiliaryFolder(table);
        return new UpgradeDowngrade.TableConfigChangeSet();
    }

    private void deleteCompactionRequestedFileFromAuxiliaryFolder(HoodieTable table) {
        HoodieTableMetaClient metaClient = table.getMetaClient();
        HoodieTimeline compactionTimeline = metaClient.getActiveTimeline().filterPendingCompactionTimeline().filter(instant -> instant.getState() == HoodieInstant.State.REQUESTED);
        InstantFileNameGenerator factory = table.getMetaClient().getInstantFileNameGenerator();
        compactionTimeline.getInstantsAsStream().forEach(deleteInstant -> {
            LOG.info("Deleting instant " + deleteInstant + " in auxiliary meta path " + metaClient.getMetaAuxiliaryPath());
            StoragePath metaFile = new StoragePath(metaClient.getMetaAuxiliaryPath(), factory.getFileName(deleteInstant));
            try {
                if (metaClient.getStorage().exists(metaFile)) {
                    metaClient.getStorage().deleteFile(metaFile);
                    LOG.info("Deleted instant file in auxiliary meta path : " + metaFile);
                }
            }
            catch (IOException e) {
                throw new HoodieUpgradeDowngradeException(HoodieTableVersion.FIVE.versionCode(), HoodieTableVersion.SIX.versionCode(), true, e);
            }
        });
    }
}

