/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.io.IOException;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FourToFiveUpgradeHandler
implements UpgradeHandler {
    private static final Logger LOG = LoggerFactory.getLogger(FourToFiveUpgradeHandler.class);

    @Override
    public UpgradeDowngrade.TableConfigChangeSet upgrade(HoodieWriteConfig config, HoodieEngineContext context, String instantTime, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        try {
            HoodieTable table = upgradeDowngradeHelper.getTable(config, context);
            if (!config.doSkipDefaultPartitionValidation().booleanValue() && this.hasDefaultPartitionPath(config, table)) {
                LOG.error(String.format("\"%s\" partition detected. From 0.12, we are changing the default partition in hudi to \"%s\". Please read and write back the data in \"%s\" partition in hudi to new partition path \"%s\". \"\nSample spark command to use to re-write the data: \n\nval df = spark.read.format(\"hudi\").load(HUDI_TABLE_PATH).filter(col(\"PARTITION_PATH_COLUMN\") === \"%s\"); \t \n\ndf.drop(\"_hoodie_commit_time\").drop(\"_hoodie_commit_seqno\").drop(\"_hoodie_record_key\")\n .drop(\"_hoodie_partition_path\").drop(\"_hoodie_file_name\").withColumn(PARTITION_PATH_COLUMN,\"%s\")\n .write.format(\"hudi\").options(writeOptions).mode(Append).save(HUDI_TABLE_PATH);\n\nPlease fix values for PARTITION_PATH_COLUMN, HUDI_TABLE_PATH and set all write configs in above command before running. Also do delete the records in old partition once above command succeeds. Sample spark command to delete old partition records: \n\nval df = spark.read.format(\"hudi\").load(HUDI_TABLE_PATH).filter(col(\"PARTITION_PATH_COLUMN\") === \"%s\");\n\ndf.write.format(\"hudi\").option(\"hoodie.datasource.write.operation\",\"delete\").options(writeOptions).mode(Append).save(HUDI_TABLE_PATH);\t\n\n", "default", "__HIVE_DEFAULT_PARTITION__", "default", "__HIVE_DEFAULT_PARTITION__", "default", "__HIVE_DEFAULT_PARTITION__", "default"));
                throw new HoodieException(String.format("Old deprecated \"%s\" partition found in hudi table. This needs a migration step before we can upgrade ", "default"));
            }
            return new UpgradeDowngrade.TableConfigChangeSet();
        }
        catch (IOException e) {
            LOG.error("Fetching file system instance failed", (Throwable)e);
            throw new HoodieException("Fetching FileSystem instance failed ", (Throwable)e);
        }
    }

    private boolean hasDefaultPartitionPath(HoodieWriteConfig config, HoodieTable table) throws IOException {
        HoodieTableConfig tableConfig = table.getMetaClient().getTableConfig();
        if (!tableConfig.isTablePartitioned()) {
            return false;
        }
        String checkPartitionPath = "default";
        boolean hiveStylePartitioningEnable = Boolean.parseBoolean(tableConfig.getHiveStylePartitioningEnable());
        if (hiveStylePartitioningEnable) {
            String[] partitions = (String[])tableConfig.getPartitionFields().get();
            checkPartitionPath = partitions[0] + "=" + "default";
        }
        return table.getStorage().exists(new StoragePath(config.getBasePath() + "/" + checkPartitionPath));
    }
}

