/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.AWSDmsAvroPayload;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.EventTimeAvroPayload;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.model.debezium.MySqlDebeziumAvroPayload;
import org.apache.hudi.common.model.debezium.PostgresDebeziumAvroPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieUpgradeDowngradeException;
import org.apache.hudi.keygen.KeyGenUtils;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.upgrade.DowngradeHandler;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeDowngradeUtils;

public class NineToEightDowngradeHandler
implements DowngradeHandler {
    @Override
    public UpgradeDowngrade.TableConfigChangeSet downgrade(HoodieWriteConfig config, HoodieEngineContext context, String instantTime, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        HoodieTable table = upgradeDowngradeHelper.getTable(config, context);
        HoodieTableMetaClient metaClient = table.getMetaClient();
        if (config.enableComplexKeygenValidation() && KeyGenUtils.isComplexKeyGeneratorWithSingleRecordKeyField(metaClient.getTableConfig())) {
            throw new HoodieUpgradeDowngradeException(KeyGenUtils.getComplexKeygenErrorMessage("downgrade"));
        }
        UpgradeDowngradeUtils.dropNonV1IndexPartitions(config, context, table, upgradeDowngradeHelper, "downgrading from table version nine to eight");
        HashSet<ConfigProperty> propertiesToRemove = new HashSet<ConfigProperty>();
        HashMap<ConfigProperty, String> propertiesToAdd = new HashMap<ConfigProperty, String>();
        HoodieTableConfig tableConfig = metaClient.getTableConfig();
        this.reconcileMergeConfigs(propertiesToAdd, propertiesToRemove, tableConfig);
        this.reconcileOrderingFieldsConfig(propertiesToAdd, propertiesToRemove, tableConfig);
        return new UpgradeDowngrade.TableConfigChangeSet(propertiesToAdd, propertiesToRemove);
    }

    private void reconcileMergeConfigs(Map<ConfigProperty, String> propertiesToAdd, Set<ConfigProperty> propertiesToRemove, HoodieTableConfig tableConfig) {
        propertiesToRemove.add(HoodieTableConfig.PARTIAL_UPDATE_MODE);
        String legacyPayloadClass = tableConfig.getLegacyPayloadClass();
        RecordMergeMode mergeMode = tableConfig.getRecordMergeMode();
        if (mergeMode == RecordMergeMode.EVENT_TIME_ORDERING) {
            propertiesToAdd.put(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID, "eeb8d96f-b1e4-49fd-bbf8-28ac514178e5");
        } else if (mergeMode == RecordMergeMode.COMMIT_TIME_ORDERING) {
            propertiesToAdd.put(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID, "ce9acb64-bde0-424c-9b91-f6ebba25356d");
        }
        if (!StringUtils.isNullOrEmpty((String)legacyPayloadClass) && UpgradeDowngradeUtils.PAYLOAD_CLASSES_TO_HANDLE.contains(legacyPayloadClass)) {
            propertiesToRemove.add(HoodieTableConfig.LEGACY_PAYLOAD_CLASS_NAME);
            propertiesToAdd.put(HoodieTableConfig.PAYLOAD_CLASS_NAME, legacyPayloadClass);
            if (!(legacyPayloadClass.equals(OverwriteWithLatestAvroPayload.class.getName()) || legacyPayloadClass.equals(DefaultHoodieRecordPayload.class.getName()) || legacyPayloadClass.equals(EventTimeAvroPayload.class.getName()))) {
                propertiesToAdd.put(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID, "00000000-0000-0000-0000-000000000000");
                propertiesToAdd.put(HoodieTableConfig.RECORD_MERGE_MODE, RecordMergeMode.CUSTOM.name());
            }
            if (legacyPayloadClass.equals(AWSDmsAvroPayload.class.getName())) {
                propertiesToRemove.add(ConfigProperty.key((String)"hoodie.record.merge.property.hoodie.payload.delete.field").noDefaultValue());
                propertiesToRemove.add(ConfigProperty.key((String)"hoodie.record.merge.property.hoodie.payload.delete.marker").noDefaultValue());
            } else if (legacyPayloadClass.equals(PostgresDebeziumAvroPayload.class.getName())) {
                propertiesToRemove.add(ConfigProperty.key((String)"hoodie.record.merge.property.hoodie.write.partial.update.unavailable.value").noDefaultValue());
                propertiesToRemove.add(ConfigProperty.key((String)"hoodie.record.merge.property.hoodie.payload.delete.field").noDefaultValue());
                propertiesToRemove.add(ConfigProperty.key((String)"hoodie.record.merge.property.hoodie.payload.delete.marker").noDefaultValue());
            } else if (legacyPayloadClass.equals(MySqlDebeziumAvroPayload.class.getName())) {
                propertiesToRemove.add(ConfigProperty.key((String)"hoodie.record.merge.property.hoodie.payload.delete.field").noDefaultValue());
                propertiesToRemove.add(ConfigProperty.key((String)"hoodie.record.merge.property.hoodie.payload.delete.marker").noDefaultValue());
            }
        }
    }

    private void reconcileOrderingFieldsConfig(Map<ConfigProperty, String> propertiesToAdd, Set<ConfigProperty> propertiesToRemove, HoodieTableConfig tableConfig) {
        Option orderingFieldsOpt = MySqlDebeziumAvroPayload.class.getName().equals(tableConfig.getLegacyPayloadClass()) ? Option.of((Object)"_event_seq") : tableConfig.getOrderingFieldsStr();
        orderingFieldsOpt.ifPresent(orderingFields -> {
            propertiesToAdd.put(HoodieTableConfig.PRECOMBINE_FIELD, (String)orderingFields);
            propertiesToRemove.add(HoodieTableConfig.ORDERING_FIELDS);
        });
    }
}

