/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.util.Collections;
import java.util.HashMap;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.HoodieTableMetadataUtil;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.upgrade.DowngradeHandler;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeDowngradeUtils;

public class SixToFiveDowngradeHandler
implements DowngradeHandler {
    @Override
    public UpgradeDowngrade.TableConfigChangeSet downgrade(HoodieWriteConfig config, HoodieEngineContext context, String instantTime, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        HoodieTable table = upgradeDowngradeHelper.getTable(config, context);
        HoodieTableMetadataUtil.deleteMetadataTable((String)config.getBasePath(), (HoodieEngineContext)context);
        UpgradeDowngradeUtils.syncCompactionRequestedFileToAuxiliaryFolder(table);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)table.getMetaClient());
        HashMap<ConfigProperty, String> updatedTableProps = new HashMap<ConfigProperty, String>();
        HoodieTableConfig tableConfig = metaClient.getTableConfig();
        Option.ofNullable((Object)tableConfig.getString(HoodieTableConfig.TABLE_METADATA_PARTITIONS)).ifPresent(v -> updatedTableProps.put(HoodieTableConfig.TABLE_METADATA_PARTITIONS, (String)v));
        Option.ofNullable((Object)tableConfig.getString(HoodieTableConfig.TABLE_METADATA_PARTITIONS_INFLIGHT)).ifPresent(v -> updatedTableProps.put(HoodieTableConfig.TABLE_METADATA_PARTITIONS_INFLIGHT, (String)v));
        return new UpgradeDowngrade.TableConfigChangeSet(updatedTableProps, Collections.emptySet());
    }
}

