/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieUpgradeDowngradeException;
import org.apache.hudi.metadata.HoodieMetadataWriteUtils;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadataWriter;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.upgrade.EightToNineUpgradeHandler;
import org.apache.hudi.table.upgrade.EightToSevenDowngradeHandler;
import org.apache.hudi.table.upgrade.FiveToFourDowngradeHandler;
import org.apache.hudi.table.upgrade.FiveToSixUpgradeHandler;
import org.apache.hudi.table.upgrade.FourToFiveUpgradeHandler;
import org.apache.hudi.table.upgrade.FourToThreeDowngradeHandler;
import org.apache.hudi.table.upgrade.NineToEightDowngradeHandler;
import org.apache.hudi.table.upgrade.OneToTwoUpgradeHandler;
import org.apache.hudi.table.upgrade.OneToZeroDowngradeHandler;
import org.apache.hudi.table.upgrade.SevenToEightUpgradeHandler;
import org.apache.hudi.table.upgrade.SevenToSixDowngradeHandler;
import org.apache.hudi.table.upgrade.SixToFiveDowngradeHandler;
import org.apache.hudi.table.upgrade.SixToSevenUpgradeHandler;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.ThreeToFourUpgradeHandler;
import org.apache.hudi.table.upgrade.ThreeToTwoDowngradeHandler;
import org.apache.hudi.table.upgrade.TwoToOneDowngradeHandler;
import org.apache.hudi.table.upgrade.TwoToThreeUpgradeHandler;
import org.apache.hudi.table.upgrade.UpgradeDowngradeUtils;
import org.apache.hudi.table.upgrade.ZeroToOneUpgradeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeDowngrade {
    private static final Logger LOG = LoggerFactory.getLogger(UpgradeDowngrade.class);
    public static final String HOODIE_UPDATED_PROPERTY_FILE = "hoodie.properties.updated";
    private static final Set<Pair<Integer, Integer>> UPGRADE_HANDLERS_REQUIRING_ROLLBACK_AND_COMPACT = new HashSet<Pair>(Arrays.asList(Pair.of((Object)7, (Object)8), Pair.of((Object)8, (Object)9)));
    private static final Set<Pair<Integer, Integer>> DOWNGRADE_HANDLERS_REQUIRING_ROLLBACK_ANDCOMPACT = new HashSet<Pair>(Arrays.asList(Pair.of((Object)8, (Object)7), Pair.of((Object)9, (Object)8), Pair.of((Object)6, (Object)5)));
    private final SupportsUpgradeDowngrade upgradeDowngradeHelper;
    private HoodieTableMetaClient metaClient;
    protected HoodieWriteConfig config;
    protected HoodieEngineContext context;

    public UpgradeDowngrade(HoodieTableMetaClient metaClient, HoodieWriteConfig config, HoodieEngineContext context, SupportsUpgradeDowngrade upgradeDowngradeHelper) {
        this.metaClient = metaClient;
        this.config = config;
        this.context = context;
        this.upgradeDowngradeHelper = upgradeDowngradeHelper;
    }

    public static boolean needsUpgradeOrDowngrade(HoodieTableMetaClient metaClient, HoodieWriteConfig config, HoodieTableVersion toWriteVersion) {
        HoodieTableVersion fromTableVersion = metaClient.getTableConfig().getTableVersion();
        return UpgradeDowngrade.needsUpgrade(metaClient, config, toWriteVersion) || UpgradeDowngrade.needsDowngrade(fromTableVersion, toWriteVersion);
    }

    public static boolean needsDowngrade(HoodieTableVersion fromTableVersion, HoodieTableVersion toWriteVersion) {
        if (toWriteVersion.lesserThan(HoodieTableVersion.SIX)) {
            throw new HoodieUpgradeDowngradeException(String.format("Hudi 1.x release only supports table version greater than version 6 or above. Please downgrade table from version %s to %s using a Hudi release prior to 1.0.0", HoodieTableVersion.SIX.versionCode(), toWriteVersion.versionCode()));
        }
        return toWriteVersion.lesserThan(fromTableVersion);
    }

    public static boolean needsUpgrade(HoodieTableMetaClient metaClient, HoodieWriteConfig config, HoodieTableVersion toWriteVersion) {
        HoodieTableVersion fromTableVersion = metaClient.getTableConfig().getTableVersion();
        if (fromTableVersion.greaterThan(toWriteVersion)) {
            LOG.info("Table version {} is greater than write version {}. No upgrade needed", (Object)fromTableVersion, (Object)toWriteVersion);
            return false;
        }
        if (fromTableVersion.equals((Object)toWriteVersion)) {
            return false;
        }
        if (fromTableVersion.lesserThan(HoodieTableVersion.SIX)) {
            throw new HoodieUpgradeDowngradeException(String.format("Hudi 1.x release only supports table version greater than version 6 or above. Please upgrade table from version %s to %s using a Hudi release prior to 1.0.0", fromTableVersion.versionCode(), HoodieTableVersion.SIX.versionCode()));
        }
        if (!config.autoUpgrade()) {
            config.setWriteVersion(fromTableVersion);
            LOG.warn("hoodie.write.auto.upgrade was disabled. Table version {} does not match write version {}. Setting hoodie.write.table.version={} to match hoodie.table.version, and skipping upgrade", new Object[]{fromTableVersion.versionCode(), toWriteVersion.versionCode(), fromTableVersion.versionCode()});
            return false;
        }
        return true;
    }

    public boolean needsUpgradeOrDowngrade(HoodieTableVersion toWriteVersion) {
        return UpgradeDowngrade.needsUpgradeOrDowngrade(this.metaClient, this.config, toWriteVersion);
    }

    public boolean needsUpgrade(HoodieTableVersion toWriteVersion) {
        return UpgradeDowngrade.needsUpgrade(this.metaClient, this.config, toWriteVersion);
    }

    public void run(HoodieTableVersion toVersion, String instantTime) {
        boolean isUpgrade;
        Object fromVersion = this.metaClient.getTableConfig().getTableVersion();
        boolean bl = isUpgrade = fromVersion.versionCode() < toVersion.versionCode();
        if (!this.needsUpgradeOrDowngrade(toVersion)) {
            return;
        }
        this.performRollbackAndCompactionIfRequired((HoodieTableVersion)fromVersion, toVersion, isUpgrade);
        if (toVersion.versionCode() >= HoodieTableVersion.FOUR.versionCode()) {
            String metadataTablePath = HoodieTableMetadata.getMetadataTableBasePath((String)this.metaClient.getBasePath().toString());
            try {
                if (this.metaClient.getStorage().exists(new StoragePath(metadataTablePath))) {
                    HoodieTableMetaClient mdtMetaClient = HoodieTableMetaClient.builder().setConf(this.metaClient.getStorageConf().newInstance()).setBasePath(metadataTablePath).build();
                    HoodieWriteConfig mdtWriteConfig = HoodieMetadataWriteUtils.createMetadataWriteConfig(this.config, HoodieFailedWritesCleaningPolicy.EAGER, this.metaClient.getTableConfig().getTableVersion());
                    new UpgradeDowngrade(mdtMetaClient, mdtWriteConfig, this.context, this.upgradeDowngradeHelper).run(toVersion, instantTime);
                }
            }
            catch (Exception e) {
                throw new HoodieUpgradeDowngradeException("Upgrade/downgrade for the Hudi metadata table failed. Please try again. If the failure repeats for metadata table, it is recommended to disable the metadata table so that the upgrade and downgrade can continue for the data table.", e);
            }
        }
        LOG.info("Attempting to move table from version " + fromVersion + " to " + toVersion);
        Hashtable<ConfigProperty, String> tablePropsToAdd = new Hashtable<ConfigProperty, String>();
        HashSet<ConfigProperty> tablePropsToRemove = new HashSet<ConfigProperty>();
        if (isUpgrade) {
            while (fromVersion.versionCode() < toVersion.versionCode()) {
                HoodieTableVersion nextVersion = HoodieTableVersion.fromVersionCode((int)(fromVersion.versionCode() + 1));
                TableConfigChangeSet tableConfigChangeSet = this.upgrade((HoodieTableVersion)fromVersion, nextVersion, instantTime);
                tablePropsToAdd.putAll(tableConfigChangeSet.propertiesToUpdate());
                tablePropsToRemove.addAll(tableConfigChangeSet.propertiesToDelete());
                fromVersion = nextVersion;
            }
        } else {
            while (fromVersion.versionCode() > toVersion.versionCode()) {
                HoodieTableVersion prevVersion = HoodieTableVersion.fromVersionCode((int)(fromVersion.versionCode() - 1));
                TableConfigChangeSet tableConfigChangeSet = this.downgrade((HoodieTableVersion)fromVersion, prevVersion, instantTime);
                tablePropsToAdd.putAll(tableConfigChangeSet.propertiesToUpdate());
                tablePropsToRemove.addAll(tableConfigChangeSet.propertiesToDelete());
                fromVersion = prevVersion;
            }
        }
        if (this.metaClient.getTableConfig().isMetadataTableAvailable()) {
            this.metaClient = HoodieTableMetaClient.reload((HoodieTableMetaClient)this.metaClient);
        }
        for (ConfigProperty configProperty : tablePropsToRemove) {
            this.metaClient.getTableConfig().clearValue(configProperty);
        }
        for (Map.Entry entry : tablePropsToAdd.entrySet()) {
            this.metaClient.getTableConfig().setValue((ConfigProperty)entry.getKey(), (String)entry.getValue());
            ((ConfigProperty)entry.getKey()).getAlternatives().forEach(alternateKey -> this.metaClient.getTableConfig().setValue((String)alternateKey, (String)entry.getValue()));
        }
        this.metaClient.getTableConfig().setTableVersion(toVersion);
        Set propertiesToRemove = tablePropsToRemove.stream().map(ConfigProperty::key).collect(Collectors.toSet());
        HoodieTableConfig.updateAndDeleteProps((HoodieStorage)this.metaClient.getStorage(), (StoragePath)this.metaClient.getMetaPath(), (Properties)this.metaClient.getTableConfig().getProps(), propertiesToRemove);
        if (this.metaClient.getTableConfig().isMetadataTableAvailable() && toVersion.equals((Object)HoodieTableVersion.SIX) && !isUpgrade) {
            TypedProperties typedProperties = this.config.getProps();
            typedProperties.setProperty(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), "6");
            typedProperties.setProperty(HoodieWriteConfig.AUTO_UPGRADE_VERSION.key(), "false");
            HoodieWriteConfig updatedConfig = HoodieWriteConfig.newBuilder().withPath(this.config.getBasePath()).withProperties((Properties)typedProperties).build();
            HoodieTable table = this.upgradeDowngradeHelper.getTable(updatedConfig, this.context);
            String newInstant = table.getMetaClient().createNewInstantTime(false);
            Option<HoodieTableMetadataWriter> mdtWriterOpt = table.getMetadataWriter(newInstant, false, false);
            mdtWriterOpt.ifPresent(mdtWriter -> {
                HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
                commitMetadata.setOperationType(WriteOperationType.UPSERT);
                mdtWriter.update(commitMetadata, newInstant);
                try {
                    mdtWriter.close();
                }
                catch (Exception e) {
                    throw new HoodieException("Failed to close MDT writer for table " + table.getConfig().getBasePath());
                }
            });
        }
    }

    protected TableConfigChangeSet upgrade(HoodieTableVersion fromVersion, HoodieTableVersion toVersion, String instantTime) {
        if (fromVersion == HoodieTableVersion.ZERO && toVersion == HoodieTableVersion.ONE) {
            return new ZeroToOneUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.ONE && toVersion == HoodieTableVersion.TWO) {
            return new OneToTwoUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.TWO && toVersion == HoodieTableVersion.THREE) {
            return new TwoToThreeUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.THREE && toVersion == HoodieTableVersion.FOUR) {
            return new ThreeToFourUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.FOUR && toVersion == HoodieTableVersion.FIVE) {
            return new FourToFiveUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.FIVE && toVersion == HoodieTableVersion.SIX) {
            return new FiveToSixUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.SIX && toVersion == HoodieTableVersion.SEVEN) {
            return new SixToSevenUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.SEVEN && toVersion == HoodieTableVersion.EIGHT) {
            return new SevenToEightUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.EIGHT && toVersion == HoodieTableVersion.NINE) {
            return new EightToNineUpgradeHandler().upgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        throw new HoodieUpgradeDowngradeException(fromVersion.versionCode(), toVersion.versionCode(), true);
    }

    protected TableConfigChangeSet downgrade(HoodieTableVersion fromVersion, HoodieTableVersion toVersion, String instantTime) {
        if (fromVersion == HoodieTableVersion.ONE && toVersion == HoodieTableVersion.ZERO) {
            return new OneToZeroDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.TWO && toVersion == HoodieTableVersion.ONE) {
            return new TwoToOneDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.THREE && toVersion == HoodieTableVersion.TWO) {
            return new ThreeToTwoDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.FOUR && toVersion == HoodieTableVersion.THREE) {
            return new FourToThreeDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.FIVE && toVersion == HoodieTableVersion.FOUR) {
            return new FiveToFourDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.SIX && toVersion == HoodieTableVersion.FIVE) {
            return new SixToFiveDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.SEVEN && toVersion == HoodieTableVersion.SIX) {
            return new SevenToSixDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.EIGHT && toVersion == HoodieTableVersion.SEVEN) {
            return new EightToSevenDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        if (fromVersion == HoodieTableVersion.NINE && toVersion == HoodieTableVersion.EIGHT) {
            return new NineToEightDowngradeHandler().downgrade(this.config, this.context, instantTime, this.upgradeDowngradeHelper);
        }
        throw new HoodieUpgradeDowngradeException(fromVersion.versionCode(), toVersion.versionCode(), false);
    }

    private void performRollbackAndCompactionIfRequired(HoodieTableVersion fromVersion, HoodieTableVersion toVersion, boolean isUpgrade) {
        HoodieTableVersion checkVersion;
        boolean requireRollbackAndCompaction = false;
        if (isUpgrade) {
            checkVersion = fromVersion;
            while (checkVersion.versionCode() < toVersion.versionCode()) {
                HoodieTableVersion nextVersion = HoodieTableVersion.fromVersionCode((int)(checkVersion.versionCode() + 1));
                if (UPGRADE_HANDLERS_REQUIRING_ROLLBACK_AND_COMPACT.contains(Pair.of((Object)checkVersion.versionCode(), (Object)nextVersion.versionCode()))) {
                    requireRollbackAndCompaction = true;
                    break;
                }
                checkVersion = nextVersion;
            }
        } else {
            checkVersion = fromVersion;
            while (checkVersion.versionCode() > toVersion.versionCode()) {
                HoodieTableVersion prevVersion = HoodieTableVersion.fromVersionCode((int)(checkVersion.versionCode() - 1));
                if (DOWNGRADE_HANDLERS_REQUIRING_ROLLBACK_ANDCOMPACT.contains(Pair.of((Object)checkVersion.versionCode(), (Object)prevVersion.versionCode()))) {
                    requireRollbackAndCompaction = true;
                    break;
                }
                checkVersion = prevVersion;
            }
        }
        if (requireRollbackAndCompaction) {
            LOG.info("Rolling back failed writes and compacting table before upgrade/downgrade");
            HoodieTableVersion tableVersion = fromVersion == HoodieTableVersion.SEVEN ? HoodieTableVersion.SIX : this.metaClient.getTableConfig().getTableVersion();
            UpgradeDowngradeUtils.rollbackFailedWritesAndCompact(this.upgradeDowngradeHelper.getTable(this.config, this.context), this.context, this.config, this.upgradeDowngradeHelper, HoodieTableType.MERGE_ON_READ.equals((Object)this.metaClient.getTableType()), tableVersion);
        }
    }

    static class TableConfigChangeSet {
        private final Map<ConfigProperty, String> propertiesToUpdate;
        private final Set<ConfigProperty> propertiesToDelete;

        public TableConfigChangeSet() {
            this.propertiesToUpdate = Collections.emptyMap();
            this.propertiesToDelete = Collections.emptySet();
        }

        public TableConfigChangeSet(Map<ConfigProperty, String> propertiesToUpdate, Set<ConfigProperty> propertiesToDelete) {
            this.propertiesToUpdate = propertiesToUpdate;
            this.propertiesToDelete = propertiesToDelete;
        }

        public Map<ConfigProperty, String> propertiesToUpdate() {
            return this.propertiesToUpdate;
        }

        public Set<ConfigProperty> propertiesToDelete() {
            return this.propertiesToDelete;
        }
    }
}

